/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.problems.AbstractProblemDoubleOffset;
import eva2.problems.InterfaceMultimodalProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="F14 function: numerous optima in linear order which may be rotated")
public class F14Problem
extends AbstractProblemDoubleOffset
implements InterfaceMultimodalProblem,
Serializable {
    double rotation = 0.0;
    double rotationDX = 2.0;

    public F14Problem() {
        this.template = new ESIndividualDoubleData();
        this.problemDimension = 2;
    }

    public F14Problem(F14Problem b) {
        super(b);
        this.rotation = b.rotation;
    }

    @Override
    public Object clone() {
        return new F14Problem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        double[] result = new double[1];
        double x0 = x[0] - this.rotationDX - this.xOffset;
        double x1 = x[1] - this.rotationDX - this.xOffset;
        if (this.rotation != 0.0) {
            double cosw = Math.cos(this.rotation);
            double sinw = Math.sin(this.rotation);
            double tmpx0 = cosw * x0 - sinw * x1;
            x1 = sinw * x0 + cosw * x1;
            x0 = tmpx0;
        }
        result[0] = this.yOffset + 36.9452804947;
        result[0] = result[0] + -Math.exp(Math.cos(3.0 * x0) + Math.cos(6.0 * x1)) * Math.exp(-x0 * x0 / 10.0) * (-0.05 * x1 * x1 + 5.0);
        return result;
    }

    public double getRotation() {
        return 57.29577951308232 * this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = Math.PI * 2 * rotation / 360.0;
    }

    public String rotationTipText() {
        return "The rotation angle in degrees.";
    }

    public String getStringRepresentationForProblem() {
        String result = "";
        result = result + "F14 function:\n";
        result = result + "Several local minima in linear order which may be rotated.\n";
        return result;
    }

    @Override
    public String getName() {
        return "F14-Problem";
    }
}

