/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.operator.postprocess.SolutionHistogram;
import eva2.problems.AbstractProblemDouble;
import eva2.problems.InterfaceInterestingHistogram;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The Levy-function, from Levy, A., and Montalvo, A. (1985)")
public class F15Problem
extends AbstractProblemDouble
implements Serializable,
InterfaceInterestingHistogram {
    private int problemDimension = 10;

    public F15Problem() {
        super.setDefaultAccuracy(1.0E-5);
        this.setDefaultRange(10.0);
    }

    public F15Problem(int d) {
        this();
        this.setProblemDimension(d);
    }

    public F15Problem(F15Problem o) {
        super(o);
        this.problemDimension = o.getProblemDimension();
        this.setDefaultRange(o.getDefaultRange());
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double t = 0.0;
        double s = 0.0;
        double sum = 0.0;
        for (int i = 0; i < x.length - 1; ++i) {
            s = x[i] - 1.0;
            t = Math.sin(Math.PI * x[i + 1]);
            sum += s * s * (1.0 + 10.0 * t * t);
        }
        s = Math.sin(Math.PI * x[0]);
        double[] y = new double[]{10.0 * s * s + sum + (double)this.problemDimension * (x[this.problemDimension - 1] - 1.0) * (x[this.problemDimension - 1] - 1.0)};
        return y;
    }

    @Override
    public void setProblemDimension(int d) {
        this.problemDimension = d;
    }

    @Override
    public Object clone() {
        return new F15Problem(this);
    }

    @Override
    public SolutionHistogram getHistogram() {
        if (this.getProblemDimension() < 15) {
            return new SolutionHistogram(0.0, 2.0, 16);
        }
        if (this.getProblemDimension() < 25) {
            return new SolutionHistogram(0.0, 4.0, 16);
        }
        return new SolutionHistogram(0.0, 8.0, 16);
    }

    @Override
    public String getName() {
        return "Levy function";
    }
}

