/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.operator.postprocess.SolutionHistogram;
import eva2.problems.AbstractProblemDouble;
import eva2.problems.Interface2DBorderProblem;
import eva2.problems.InterfaceInterestingHistogram;
import eva2.problems.InterfaceMultimodalProblem;
import eva2.util.annotation.Description;

@Description(value="Vincent function: Multiple optima with increasing densitiy near the lower bounds, therefore decreasing attractor size. All have an equal best fitness of zero")
public class F16Problem
extends AbstractProblemDouble
implements InterfaceMultimodalProblem,
Interface2DBorderProblem,
InterfaceInterestingHistogram {
    int problemDimension = 10;

    public F16Problem() {
        this.problemDimension = 10;
    }

    public F16Problem(F16Problem other) {
        this.problemDimension = other.problemDimension;
    }

    public F16Problem(int theDim) {
        this.problemDimension = theDim;
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] res = new double[1];
        double sum = 0.0;
        for (int i = 0; i < this.getProblemDimension(); ++i) {
            sum += Math.sin(10.0 * Math.log(x[i]));
        }
        res[0] = 1.0 - 1.0 / (double)this.getProblemDimension() * sum;
        return res;
    }

    @Override
    public void setProblemDimension(int newDim) {
        this.problemDimension = newDim;
    }

    @Override
    public Object clone() {
        return new F16Problem(this);
    }

    @Override
    public double getRangeLowerBound(int n) {
        return 0.25;
    }

    @Override
    public double getRangeUpperBound(int n) {
        return 10.0;
    }

    @Override
    public String getName() {
        return "Vincent";
    }

    @Override
    public SolutionHistogram getHistogram() {
        return new SolutionHistogram(-0.001, 0.599, 15);
    }
}

