/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.operator.postprocess.SolutionHistogram;
import eva2.problems.AbstractProblemDouble;
import eva2.problems.InterfaceInterestingHistogram;
import eva2.problems.InterfaceMultimodalProblem;
import eva2.util.annotation.Description;

@Description(value="Bohachevsky function, numerous optima on an oval hyperparabola with similar attractor sizes but decreasing fitness towards the bounds")
public class F17Problem
extends AbstractProblemDouble
implements InterfaceMultimodalProblem,
InterfaceInterestingHistogram {
    int problemDimension = 10;

    public F17Problem() {
        this.setDefaultRange(10.0);
        this.problemDimension = 10;
    }

    public F17Problem(int dimension) {
        this();
        this.setProblemDimension(dimension);
    }

    public F17Problem(F17Problem other) {
        super(other);
        this.problemDimension = other.problemDimension;
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] res = new double[1];
        double sum = 0.0;
        for (int i = 0; i < this.getProblemDimension() - 1; ++i) {
            sum += x[i] * x[i] + 2.0 * (x[i + 1] * x[i + 1]);
            sum += 0.7 - 0.3 * Math.cos(Math.PI * 3 * x[i]) - 0.4 * Math.cos(Math.PI * 4 * x[i + 1]);
        }
        res[0] = sum;
        return res;
    }

    @Override
    public void setProblemDimension(int newDim) {
        this.problemDimension = newDim;
    }

    @Override
    public Object clone() {
        return new F17Problem(this);
    }

    @Override
    public String getName() {
        return "F17-Problem";
    }

    @Override
    public SolutionHistogram getHistogram() {
        if (this.getProblemDimension() < 15) {
            return new SolutionHistogram(-0.5, 7.5, 16);
        }
        return new SolutionHistogram(-0.5, 15.5, 16);
    }
}

