/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.problems.AbstractProblemDouble;
import eva2.problems.InterfaceMultimodalProblem;
import eva2.util.annotation.Description;

@Description(value="N-Function from Shir&Baeck, PPSN 2006")
public class F18Problem
extends AbstractProblemDouble
implements InterfaceMultimodalProblem {
    int problemDimension = 10;
    double alpha = 1.0;

    public F18Problem() {
        this.problemDimension = 10;
    }

    public F18Problem(F18Problem other) {
        this.problemDimension = other.problemDimension;
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] res = new double[1];
        double sum = 0.0;
        for (int i = 0; i < this.getProblemDimension(); ++i) {
            sum += Math.pow(Math.sin(Math.PI * 5 * x[i]), this.alpha);
        }
        res[0] = 1.0 - sum / (double)this.getProblemDimension();
        return res;
    }

    @Override
    public double getRangeLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getRangeUpperBound(int n) {
        return 1.0;
    }

    @Override
    public void setProblemDimension(int newDim) {
        this.problemDimension = newDim;
    }

    @Override
    public Object clone() {
        return new F18Problem(this);
    }

    @Override
    public String getName() {
        return "F18-Problem";
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }
}

