/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.operator.postprocess.SolutionHistogram;
import eva2.problems.AbstractProblemDouble;
import eva2.problems.InterfaceFirstOrderDerivableProblem;
import eva2.problems.InterfaceInterestingHistogram;
import eva2.problems.InterfaceMultimodalProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.util.Arrays;
import java.util.Random;

@Description(value="Fletcher-Powell function")
public class F19Problem
extends AbstractProblemDouble
implements InterfaceMultimodalProblem,
InterfaceInterestingHistogram,
InterfaceFirstOrderDerivableProblem {
    int problemDimension = 10;
    private transient double[] alphas;
    private transient double[] As;
    private transient int[] A;
    private transient int[] B;
    private long randSeed = 23L;

    public F19Problem() {
        this.alphas = null;
        this.problemDimension = 10;
        this.setDefaultRange(Math.PI);
    }

    public F19Problem(F19Problem other) {
        this.problemDimension = other.problemDimension;
        this.alphas = null;
    }

    public F19Problem(int d) {
        this();
        this.setProblemDimension(d);
    }

    @Override
    public void initializeProblem() {
        super.initializeProblem();
        Random rand = new Random();
        rand.setSeed(this.randSeed);
        this.alphas = RNG.randomDoubleArray(rand, -Math.PI, Math.PI, this.problemDimension);
        this.A = RNG.randomIntArray(rand, -100, 100, this.problemDimension * this.problemDimension);
        this.B = RNG.randomIntArray(rand, -100, 100, this.problemDimension * this.problemDimension);
        this.As = this.transform(this.alphas);
    }

    private double[] transform(double[] x) {
        double[] v = new double[this.problemDimension];
        Arrays.fill(v, 0.0);
        for (int i = 0; i < this.problemDimension; ++i) {
            for (int j = 0; j < this.problemDimension; ++j) {
                int n = i;
                v[n] = v[n] + ((double)this.get(this.A, i, j) * Math.sin(x[j]) + (double)this.get(this.B, i, j) * Math.cos(x[j]));
            }
        }
        return v;
    }

    private double derivedTransform(double[] x, int i, int j) {
        double v = (double)this.get(this.A, i, j) * Math.cos(x[j]) - (double)this.get(this.B, i, j) * Math.sin(x[j]);
        return v;
    }

    private int get(int[] M, int i, int j) {
        return M[i * this.problemDimension + j];
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] res = new double[1];
        double[] Bs = this.transform(x);
        double sum = 0.0;
        for (int i = 0; i < this.getProblemDimension(); ++i) {
            sum += Math.pow(this.As[i] - Bs[i], 2.0);
        }
        res[0] = sum;
        return res;
    }

    @Override
    public void setProblemDimension(int newDim) {
        this.problemDimension = newDim;
        if (this.alphas != null && newDim > this.alphas.length) {
            this.alphas = null;
            this.A = null;
            this.B = null;
        }
    }

    @Override
    public Object clone() {
        return new F19Problem(this);
    }

    @Override
    public String getName() {
        return "F19-Problem";
    }

    @Override
    public SolutionHistogram getHistogram() {
        if (this.getProblemDimension() < 15) {
            return new SolutionHistogram(0.0, 8.0, 16);
        }
        return new SolutionHistogram(0.0, 40000.0, 16);
    }

    @Override
    public double[] getFirstOrderGradients(double[] x) {
        x = this.rotateMaybe(x);
        double[] res = new double[x.length];
        double[] Bs = this.transform(x);
        for (int k = 0; k < this.getProblemDimension(); ++k) {
            double sum = 0.0;
            for (int i = 0; i < this.getProblemDimension(); ++i) {
                sum += -2.0 * this.As[i] * this.derivedTransform(x, i, k) + 2.0 * Bs[i] * this.derivedTransform(x, i, k);
            }
            res[k] = sum;
        }
        return res;
    }
}

