/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractProblemDoubleOffset;
import eva2.problems.Interface2DBorderProblem;
import eva2.problems.InterfaceFirstOrderDerivableProblem;
import eva2.problems.InterfaceHasInitRange;
import eva2.tools.math.Mathematics;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Sphere Problem")
public class F1Problem
extends AbstractProblemDoubleOffset
implements Interface2DBorderProblem,
InterfaceHasInitRange,
Serializable,
InterfaceFirstOrderDerivableProblem {
    private double initialRangeRatio = 1.0;

    public F1Problem() {
        this.setDefaultRange(10.0);
    }

    public F1Problem(F1Problem b) {
        super.cloneObjects(b);
    }

    public F1Problem(int dim) {
        super(dim);
    }

    public F1Problem(int dim, double defRange) {
        this(dim);
        this.setDefaultRange(defRange);
    }

    @Override
    public Object clone() {
        return new F1Problem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[]{this.yOffset};
        for (int i = 0; i < x.length; ++i) {
            result[0] = result[0] + Math.pow(x[i] - this.xOffset, 2.0);
        }
        return result;
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("F1 Sphere model:\n");
        sb.append("Here the individual codes a vector of real number x and F1(x)= x^2 is to be minimized.\nParameters:\n");
        sb.append("Dimension   : ");
        sb.append(this.problemDimension);
        sb.append("\nNoise level : ");
        sb.append(this.getNoise());
        return sb.toString();
    }

    @Override
    public String getName() {
        return "Sphere";
    }

    @Override
    public double[] getFirstOrderGradients(double[] x) {
        x = this.rotateMaybe(x);
        double[] grads = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            grads[i] = 2.0 * (x[i] - this.xOffset);
        }
        return grads;
    }

    @Override
    public Object getInitializationRange() {
        if (this.initialRangeRatio < 1.0) {
            double[][] gR = this.makeRange();
            double[][] initR = this.makeRange();
            Mathematics.scaleRange(this.initialRangeRatio, initR);
            for (int i = 0; i < this.getProblemDimension(); ++i) {
                double d = gR[i][0] - initR[i][0];
                double[] dArray = initR[i];
                dArray[0] = dArray[0] + d;
                double[] dArray2 = initR[i];
                dArray2[1] = dArray2[1] + d;
            }
            return initR;
        }
        return this.makeRange();
    }
}

