/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.operator.postprocess.SolutionHistogram;
import eva2.problems.AbstractProblemDouble;
import eva2.problems.InterfaceInterestingHistogram;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The Rana function is non-separable, highly multi-modal and multi-funnel. There are diagonal ridges across the search space and the optima are close to the bounds.The minimum fitness f(x*) is close to (n-1)*r for dimension n and default range r, by which this implementation may be shifted to the positive domain.")
public class F20Problem
extends AbstractProblemDouble
implements Serializable,
InterfaceInterestingHistogram {
    private int problemDimension = 10;
    private boolean shiftFit = false;

    public F20Problem() {
        this.setDefaultRange(512.0);
    }

    public F20Problem(int problemDimension, boolean rotate) {
        this();
        this.setProblemDimension(problemDimension);
        this.setDoRotation(rotate);
    }

    public F20Problem(F20Problem o) {
        super(o);
        this.setDefaultRange(512.0);
        this.problemDimension = o.problemDimension;
        this.setShiftFit(o.isShiftFit());
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double sum = this.getYOffset();
        for (int i = 0; i < x.length - 1; ++i) {
            sum += this.g(x[i], x[i + 1]);
        }
        return new double[]{sum};
    }

    private double getYOffset() {
        if (this.isShiftFit()) {
            return (double)(this.getProblemDimension() - 1) * this.getDefaultRange();
        }
        return 0.0;
    }

    private double g(double x, double y) {
        double a = this.beta(-x, y);
        double b = this.beta(x, y);
        return x * Math.sin(a) * Math.cos(b) + (y + 1.0) * Math.cos(a) * Math.sin(b);
    }

    private double beta(double x, double y) {
        return Math.sqrt(Math.abs(x + y + 1.0));
    }

    @Override
    public void setProblemDimension(int newDim) {
        this.problemDimension = newDim;
    }

    @Override
    public Object clone() {
        return new F20Problem(this);
    }

    @Override
    public String getName() {
        return "Rana" + (this.isDoRotation() ? "-rot" : "");
    }

    public void setShiftFit(boolean shiftFit) {
        this.shiftFit = shiftFit;
    }

    public boolean isShiftFit() {
        return this.shiftFit;
    }

    @Override
    public SolutionHistogram getHistogram() {
        if (this.getProblemDimension() == 10) {
            if (this.getYOffset() == 0.0) {
                return new SolutionHistogram(-5200.0, -3600.0, 16);
            }
            return new SolutionHistogram(0.0, 1600.0, 16);
        }
        if (this.getProblemDimension() == 30) {
            if (this.getYOffset() == 0.0) {
                return new SolutionHistogram(-15000.0, -8600.0, 16);
            }
            return new SolutionHistogram(0.0, 6400.0, 16);
        }
        if (this.getProblemDimension() <= 5) {
            double lower = this.getYOffset() - (double)(this.getProblemDimension() - 1) * this.getDefaultRange();
            return new SolutionHistogram(lower, lower + 160.0, 16);
        }
        if (this.getProblemDimension() < 15) {
            return new SolutionHistogram(this.getYOffset() - 5000.0, this.getYOffset() - 3400.0, 16);
        }
        return new SolutionHistogram(this.getYOffset() - 15000.0, this.getYOffset() - 13400.0, 16);
    }
}

