/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.operator.postprocess.SolutionHistogram;
import eva2.problems.AbstractProblemDouble;
import eva2.problems.InterfaceInterestingHistogram;
import eva2.problems.InterfaceMultimodalProblem;
import eva2.util.annotation.Description;
import java.util.Random;

@Description(value="Langerman function")
public class F21Problem
extends AbstractProblemDouble
implements InterfaceMultimodalProblem,
InterfaceInterestingHistogram {
    private double[] heights = null;
    private double[][] peaks = null;
    private static final int rndSeed = 23;
    private int problemDimension = 2;

    public F21Problem() {
    }

    public F21Problem(F21Problem f21Problem) {
        this();
    }

    @Override
    public String getName() {
        return "Langerman";
    }

    @Override
    public double getRangeLowerBound(int dim) {
        return 0.0;
    }

    @Override
    public double getRangeUpperBound(int dim) {
        return 10.0;
    }

    @Override
    public void initializeProblem() {
        super.initializeProblem();
        Random rnd = new Random(23L);
        this.heights = new double[this.getProblemDimension()];
        this.peaks = new double[this.getProblemDimension()][];
        for (int i = 0; i < this.getProblemDimension(); ++i) {
            this.heights[i] = rnd.nextDouble();
            this.peaks[i] = new double[this.getProblemDimension()];
            for (int j = 0; j < this.getProblemDimension(); ++j) {
                this.peaks[i][j] = this.getRangeLowerBound(i) + rnd.nextDouble() * (this.getRangeUpperBound(i) - this.getRangeLowerBound(i));
            }
        }
    }

    @Override
    public double[] evaluate(double[] x) {
        double[] res = new double[1];
        double sum = 0.0;
        x = this.rotateMaybe(x);
        for (int i = 0; i < x.length; ++i) {
            double innerSum = 0.0;
            for (int j = 0; j < x.length; ++j) {
                double tmp = x[j] - this.peaks[i][j];
                innerSum += tmp * tmp;
            }
            sum += this.heights[i] * Math.exp(-0.3183098861837907 * innerSum) * Math.cos(Math.PI * innerSum);
        }
        res[0] = 1.0 - sum;
        return res;
    }

    @Override
    public void setProblemDimension(int d) {
        this.problemDimension = d;
    }

    public String problemDimensionTipText() {
        return "The problem dimension and number of optima.";
    }

    @Override
    public Object clone() {
        return new F21Problem(this);
    }

    @Override
    public SolutionHistogram getHistogram() {
        return new SolutionHistogram(0.0, 0.5, 10);
    }
}

