/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractProblemDoubleOffset;
import eva2.problems.InterfaceHasInitRange;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Schwefel 2.22")
public class F22Problem
extends AbstractProblemDoubleOffset
implements InterfaceHasInitRange,
Serializable {
    public F22Problem() {
        this.setDefaultRange(10.0);
    }

    public F22Problem(F22Problem b) {
        super.cloneObjects(b);
    }

    public F22Problem(int dim) {
        super(dim);
    }

    public F22Problem(int dim, double defRange) {
        this(dim);
        this.setDefaultRange(defRange);
    }

    @Override
    public Object clone() {
        return new F22Problem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[]{this.yOffset};
        double sum = 0.0;
        double product = 1.0;
        for (int i = 0; i < x.length; ++i) {
            sum += Math.abs(x[i]);
            product *= Math.abs(x[i]);
        }
        result[0] = sum + product;
        return result;
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("F22 Schwefel 2.22 model:\n");
        sb.append("Here the individual codes a vector of real number x and F22(x) is to be minimized.\nParameters:\n");
        sb.append("Dimension   : ");
        sb.append(this.problemDimension);
        sb.append("\nNoise level : ");
        sb.append(this.getNoise());
        return sb.toString();
    }

    @Override
    public String getName() {
        return "Schwefel 2.22";
    }

    @Override
    public Object getInitializationRange() {
        return this.makeRange();
    }
}

