/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractProblemDoubleOffset;
import eva2.problems.InterfaceHasInitRange;
import eva2.tools.math.Mathematics;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Generalized Schaffer")
public class F23Problem
extends AbstractProblemDoubleOffset
implements InterfaceHasInitRange,
Serializable {
    private double initialRangeRatio = 1.0;

    public F23Problem() {
        this.setDefaultRange(100.0);
    }

    public F23Problem(F23Problem b) {
        super.cloneObjects(b);
    }

    public F23Problem(int dim) {
        super(dim);
    }

    public F23Problem(int dim, double defRange) {
        this(dim);
        this.setDefaultRange(defRange);
    }

    @Override
    public Object clone() {
        return new F23Problem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[1];
        double sum = 0.0;
        result[0] = this.yOffset;
        for (double value : x) {
            sum += Math.pow(value, 2.0);
        }
        result[0] = result[0] + (0.5 + (Math.pow(Math.sin(Math.sqrt(sum)), 2.0) - 0.5) / Math.pow(1.0 + 0.001 * sum, 2.0));
        return result;
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("F23 Generalized Schaffer:\n");
        sb.append("Here the individual codes a vector of real number x and F23(x) is to be minimized.\nParameters:\n");
        sb.append("Dimension   : ");
        sb.append(this.problemDimension);
        sb.append("\nNoise level : ");
        sb.append(this.getNoise());
        return sb.toString();
    }

    @Override
    public String getName() {
        return "Generalized Schaffer";
    }

    @Override
    public Object getInitializationRange() {
        if (this.initialRangeRatio < 1.0) {
            double[][] gR = this.makeRange();
            double[][] initR = this.makeRange();
            Mathematics.scaleRange(this.initialRangeRatio, initR);
            for (int i = 0; i < this.getProblemDimension(); ++i) {
                double d = gR[i][0] - initR[i][0];
                double[] dArray = initR[i];
                dArray[0] = dArray[0] + d;
                double[] dArray2 = initR[i];
                dArray2[1] = dArray2[1] + d;
            }
            return initR;
        }
        return this.makeRange();
    }
}

