/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.problems.AbstractProblemDoubleOffset;
import eva2.problems.InterfaceHasInitRange;
import eva2.tools.math.Mathematics;
import eva2.util.annotation.Description;

@Description(value="Zakharov function")
public class F24Problem
extends AbstractProblemDoubleOffset
implements InterfaceHasInitRange {
    private double initialRangeRatio = 1.0;

    public F24Problem() {
        this.setDefaultRange(10.0);
    }

    public F24Problem(F24Problem b) {
        super.cloneObjects(b);
    }

    public F24Problem(int dim) {
        super(dim);
    }

    public F24Problem(int dim, double defRange) {
        this(dim);
        this.setDefaultRange(defRange);
    }

    @Override
    public Object clone() {
        return new F24Problem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum1 += Math.pow(x[i], 2.0);
            sum2 += Math.pow(0.5 * (double)i * Math.pow(x[i], 2.0), 2.0);
            sum3 += Math.pow(0.5 * (double)i * Math.pow(x[i], 2.0), 4.0);
        }
        return new double[]{sum1 + sum2 + sum3};
    }

    @Override
    public String getName() {
        return "Zakharov";
    }

    @Override
    public Object getInitializationRange() {
        if (this.initialRangeRatio < 1.0) {
            double[][] gR = this.makeRange();
            double[][] initR = this.makeRange();
            Mathematics.scaleRange(this.initialRangeRatio, initR);
            for (int i = 0; i < this.getProblemDimension(); ++i) {
                double d = gR[i][0] - initR[i][0];
                double[] dArray = initR[i];
                dArray[0] = dArray[0] + d;
                double[] dArray2 = initR[i];
                dArray2[1] = dArray2[1] + d;
            }
            return initR;
        }
        return this.makeRange();
    }
}

