/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.GradientDescentAlgorithm;
import eva2.problems.AbstractProblemDoubleOffset;
import eva2.problems.InterfaceFirstOrderDerivableProblem;
import eva2.problems.InterfaceLocalSearchable;
import eva2.problems.InterfaceMultimodalProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Generalized Rosenbrock's function.")
public class F2Problem
extends AbstractProblemDoubleOffset
implements InterfaceLocalSearchable,
InterfaceMultimodalProblem,
Serializable,
InterfaceFirstOrderDerivableProblem {
    private transient GradientDescentAlgorithm localSearchOptimizer = null;

    public F2Problem() {
        this.template = new ESIndividualDoubleData();
    }

    public F2Problem(F2Problem b) {
        super(b);
    }

    public F2Problem(int dim) {
        super(dim);
    }

    @Override
    public Object clone() {
        return new F2Problem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[]{this.yOffset};
        for (int i = 0; i < x.length - 1; ++i) {
            double xi = x[i] - this.xOffset;
            double xii = x[i + 1] - this.xOffset;
            result[0] = result[0] + (100.0 * (xii - xi * xi) * (xii - xi * xi) + (xi - 1.0) * (xi - 1.0));
        }
        if (this.yOffset == 0.0 && result[0] <= 0.0) {
            result[0] = Math.sqrt(Double.MIN_VALUE);
        }
        return result;
    }

    @Override
    public double[] getFirstOrderGradients(double[] x) {
        x = this.rotateMaybe(x);
        int dim = x.length;
        double[] result = new double[dim];
        for (int i = 0; i < dim - 1; ++i) {
            double xi = x[i] - this.xOffset;
            double xii = x[i + 1] - this.xOffset;
            int n = i;
            result[n] = result[n] + (400.0 * xi * (xi * xi - xii) + 2.0 * xi - 2.0);
            int n2 = i + 1;
            result[n2] = result[n2] + -200.0 * (xi * xi - xii);
        }
        return result;
    }

    public String getStringRepresentationForProblem() {
        String result = "";
        result = result + "F2 Generalized Rosenbrock function:\n";
        result = result + "This problem has a deceptive optimum at (0,0,..), the true optimum is at (1,1,1,..).\n";
        result = result + "Parameters:\n";
        result = result + "Dimension   : " + this.problemDimension + "\n";
        result = result + "Noise level : " + this.getNoise() + "\n";
        result = result + "Solution representation:\n";
        return result;
    }

    @Override
    public String getName() {
        return "Generalized Rosenbrock";
    }

    @Override
    public void doLocalSearch(Population pop) {
        if (this.localSearchOptimizer == null) {
            this.initLS();
        }
        this.localSearchOptimizer.setPopulation(pop);
        this.localSearchOptimizer.optimize();
    }

    private void initLS() {
        this.localSearchOptimizer = new GradientDescentAlgorithm();
        this.localSearchOptimizer.setProblem(this);
        this.localSearchOptimizer.initialize();
    }

    @Override
    public double getLocalSearchStepFunctionCallEquivalent() {
        double cost = 1.0;
        if (this.localSearchOptimizer instanceof GradientDescentAlgorithm) {
            cost = this.localSearchOptimizer.getIterations();
        }
        return cost;
    }
}

