/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.problems.AbstractProblemDoubleOffset;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Quadratic Function with noise.")
public class F4Problem
extends AbstractProblemDoubleOffset
implements Serializable {
    static final double f4range = 1.28;

    public F4Problem() {
        this.setDefaultRange(1.28);
    }

    public F4Problem(F4Problem b) {
        super(b);
    }

    @Override
    public Object clone() {
        return new F4Problem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[]{this.yOffset};
        for (int i = 0; i < x.length - 1; ++i) {
            result[0] = result[0] + (double)(i + 1) * Math.pow(x[i] - this.xOffset, 4.0);
        }
        return result;
    }

    public String getStringRepresentationForProblem() {
        String result = "";
        result = result + "F4 Quadratic Function with noise:\n";
        result = result + "This problem is noisy.\n";
        result = result + "Parameters:\n";
        result = result + "Dimension   : " + this.problemDimension + "\n";
        result = result + "Noise level : " + this.getNoise() + "\n";
        result = result + "Solution representation:\n";
        return result;
    }

    @Override
    public String getName() {
        return "Noisy Quaric";
    }
}

