/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.problems.AbstractProblemDoubleOffset;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Schwefel's 1.2 Function.")
public class F5Problem
extends AbstractProblemDoubleOffset
implements Serializable {
    static final double f5range = 65.536;

    public F5Problem() {
        this.setDefaultRange(65.536);
    }

    public F5Problem(F5Problem b) {
        super(b);
    }

    @Override
    public Object clone() {
        return new F5Problem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[]{this.yOffset};
        for (int i = 0; i < x.length; ++i) {
            double tmp = 0.0;
            for (int j = 0; j <= i; ++j) {
                tmp += x[j] - this.xOffset;
            }
            result[0] = result[0] + Math.pow(tmp, 2.0);
        }
        return result;
    }

    public String getStringRepresentationForProblem() {
        String result = "";
        result = result + "F5 Schwefel's 1.2 Function:\n";
        result = result + "This problem is unimodal.\n";
        result = result + "Parameters:\n";
        result = result + "Dimension   : " + this.problemDimension + "\n";
        result = result + "Noise level : " + this.getNoise() + "\n";
        result = result + "Solution representation:\n";
        return result;
    }

    @Override
    public String getName() {
        return "Schwefel 1.2";
    }
}

