/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.operator.postprocess.SolutionHistogram;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.GradientDescentAlgorithm;
import eva2.problems.AbstractProblemDoubleOffset;
import eva2.problems.InterfaceFirstOrderDerivableProblem;
import eva2.problems.InterfaceInterestingHistogram;
import eva2.problems.InterfaceLocalSearchable;
import eva2.problems.InterfaceMultimodalProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Generalized Rastrigin's function.")
public class F6Problem
extends AbstractProblemDoubleOffset
implements InterfaceMultimodalProblem,
InterfaceFirstOrderDerivableProblem,
InterfaceLocalSearchable,
Serializable,
InterfaceInterestingHistogram {
    private double a = 10.0;
    private double omega = Math.PI * 2;
    private transient GradientDescentAlgorithm localSearchOptimizer = null;

    public F6Problem() {
        this.template = new ESIndividualDoubleData();
    }

    public F6Problem(F6Problem b) {
        super(b);
        this.a = b.a;
        this.omega = b.omega;
    }

    public F6Problem(int dim) {
        super(dim);
    }

    @Override
    public Object clone() {
        return new F6Problem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[]{(double)x.length * this.a + this.yOffset};
        for (int i = 0; i < x.length; ++i) {
            double xi = x[i] - this.xOffset;
            result[0] = result[0] + (Math.pow(xi, 2.0) - this.a * Math.cos(this.omega * xi));
        }
        return result;
    }

    @Override
    public double[] getFirstOrderGradients(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[x.length];
        int j = 0;
        while (j < x.length) {
            result[j] = 0.0;
            double xj = x[j] - this.xOffset;
            int n = j++;
            result[n] = result[n] + (2.0 * xj + this.omega * this.a * Math.sin(this.omega * xj));
        }
        return result;
    }

    public String getStringRepresentationForProblem() {
        String result = "";
        result = result + "F6 Generalized Rastrigin's Function:\n";
        result = result + "Parameters:\n";
        result = result + "Dimension   : " + this.problemDimension + "\n";
        result = result + "Noise level : " + this.getNoise() + "\n";
        result = result + "Solution representation:\n";
        return result;
    }

    @Override
    public String getName() {
        return "Generalized Rastrigin";
    }

    public void setA(double a) {
        this.a = a;
    }

    public double getA() {
        return this.a;
    }

    public String aTipText() {
        return "Choose a value for A.";
    }

    public void setOmega(double Omega) {
        this.omega = Omega;
    }

    public double getOmega() {
        return this.omega;
    }

    public String omegaTipText() {
        return "Choose Omega.";
    }

    @Override
    public void setDefaultAccuracy(double acc) {
        super.setDefaultAccuracy(acc);
    }

    @Override
    public SolutionHistogram getHistogram() {
        if (this.getProblemDimension() < 15) {
            return new SolutionHistogram(-0.5, 15.5, 16);
        }
        if (this.getProblemDimension() < 25) {
            return new SolutionHistogram(-0.5, 39.5, 16);
        }
        return new SolutionHistogram(0.0, 80.0, 16);
    }

    @Override
    public void doLocalSearch(Population pop) {
        if (this.localSearchOptimizer == null) {
            this.initLS();
        }
        this.localSearchOptimizer.setPopulation(pop);
        this.localSearchOptimizer.optimize();
    }

    private void initLS() {
        this.localSearchOptimizer = new GradientDescentAlgorithm();
        this.localSearchOptimizer.setProblem(this);
        this.localSearchOptimizer.initialize();
    }

    @Override
    public double getLocalSearchStepFunctionCallEquivalent() {
        double cost = 1.0;
        if (this.localSearchOptimizer instanceof GradientDescentAlgorithm) {
            cost = this.localSearchOptimizer.getIterations();
        }
        return cost;
    }
}

