/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.population.Population;
import eva2.problems.AbstractProblemDoubleOffset;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.io.Serializable;

@Description(value="Sphere Model, changing Environment.")
public class F7Problem
extends AbstractProblemDoubleOffset
implements Serializable {
    private double t = 250.0;
    private double change = 4.0;
    protected TimeIntervalType timeIntervalType;
    private int currentTimeStamp;

    public F7Problem() {
        this.timeIntervalType = TimeIntervalType.FunctionCalls;
        this.template = new ESIndividualDoubleData();
    }

    public F7Problem(F7Problem b) {
        super(b);
        this.change = b.change;
        this.t = b.t;
        this.timeIntervalType = b.timeIntervalType;
    }

    @Override
    public Object clone() {
        return new F7Problem(this);
    }

    @Override
    public void evaluate(Population population) {
        this.evaluatePopulationStart(population);
        for (int i = 0; i < population.size(); ++i) {
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)population.get(i);
            tmpIndy.resetConstraintViolation();
            this.currentTimeStamp = this.timeIntervalType == TimeIntervalType.FunctionCalls ? population.getFunctionCalls() : population.getGeneration();
            this.evaluate(tmpIndy);
            population.incrFunctionCalls();
        }
        this.evaluatePopulationEnd(population);
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[]{this.yOffset};
        if (Math.floor((double)this.currentTimeStamp / this.t) % 2.0 == 0.0) {
            for (int i = 0; i < x.length - 1; ++i) {
                result[0] = result[0] + Math.pow(x[i] - this.xOffset, 2.0);
            }
        } else {
            for (int i = 0; i < x.length - 1; ++i) {
                result[0] = result[0] + Math.pow(x[i] - this.xOffset - this.change, 2.0);
            }
        }
        return result;
    }

    public String getStringRepresentationForProblem() {
        String result = "";
        result = result + "F7 Sphere Model, changing Environemt:\n";
        result = result + "Parameters:\n";
        result = result + "Dimension   : " + this.problemDimension + "\n";
        result = result + "Noise level : " + this.getNoise() + "\n";
        result = result + "Solution representation:\n";
        return result;
    }

    @Override
    public String getName() {
        return "Changing Sphere";
    }

    @Parameter(description="Set the time interval for environmental change.")
    public void sett(double d) {
        if (d < 1.0) {
            d = 1.0;
        }
        this.t = d;
    }

    public double gett() {
        return this.t;
    }

    @Parameter(description="Set the amount of environmental change (x[i]-b).")
    public void setChange(double d) {
        this.change = d;
    }

    public double getChange() {
        return this.change;
    }

    @Parameter(description="Choose the timeinterval type.")
    public void setTimeIntervalType(TimeIntervalType d) {
        this.timeIntervalType = d;
    }

    public TimeIntervalType getTimeIntervalType() {
        return this.timeIntervalType;
    }

    public static enum TimeIntervalType {
        FunctionCalls,
        Generation;

    }
}

