/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.distancemetric.EuclideanMetric;
import eva2.optimization.operator.postprocess.SolutionHistogram;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.problems.AbstractMultiModalProblemKnown;
import eva2.problems.AbstractProblemDouble;
import eva2.problems.AbstractProblemDoubleOffset;
import eva2.problems.InterfaceInterestingHistogram;
import eva2.problems.InterfaceMultimodalProblem;
import eva2.problems.InterfaceMultimodalProblemKnown;
import eva2.tools.ToolBox;
import eva2.tools.math.Mathematics;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.Arrays;

@Description(value="Ackley's function.")
public class F8Problem
extends AbstractProblemDoubleOffset
implements InterfaceInterestingHistogram,
InterfaceMultimodalProblem,
InterfaceMultimodalProblemKnown,
Serializable {
    protected transient Population listOfOptima = null;
    private static transient boolean stateInitializingOptima = false;
    private double a = 20.0;
    private double b = 0.2;
    private double c = Math.PI * 2;
    static final double f8Range = 32.768;

    public F8Problem() {
        this.setDefaultRange(32.768);
    }

    public F8Problem(F8Problem b) {
        super(b);
        this.a = b.a;
        this.b = b.b;
        this.c = b.c;
    }

    public F8Problem(int dim) {
        super(dim);
        this.setDefaultRange(32.768);
    }

    @Override
    public Object clone() {
        return new F8Problem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[1];
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double xi = x[i] - this.xOffset;
            sum1 += xi * xi;
            sum2 += Math.cos(this.c * xi);
        }
        double exp1 = -this.b * Math.sqrt(sum1 / (double)this.problemDimension);
        double exp2 = sum2 / (double)this.problemDimension;
        result[0] = this.yOffset + this.a + Math.E - this.a * Math.exp(exp1) - Math.exp(exp2);
        return result;
    }

    public String getStringRepresentationForProblem() {
        String result = "";
        result = result + "F8 Ackley's function.\n";
        result = result + "This problem is multimodal.\n";
        result = result + "Parameters:\n";
        result = result + "Dimension   : " + this.problemDimension + "\n";
        result = result + "Noise level : " + this.getNoise() + "\n";
        result = result + "Solution representation:\n";
        return result;
    }

    @Override
    public void initializeProblem() {
        super.initializeProblem();
        this.initListOfOptima();
    }

    @Override
    public String getName() {
        return "Ackley";
    }

    @Override
    public SolutionHistogram getHistogram() {
        if (this.getProblemDimension() < 15) {
            return new SolutionHistogram(-0.1, 7.9, 16);
        }
        if (this.getProblemDimension() < 25) {
            return new SolutionHistogram(-0.5, 15.5, 16);
        }
        return new SolutionHistogram(0.0, 16.0, 16);
    }

    @Override
    public boolean fullListAvailable() {
        return true;
    }

    @Override
    public double getMaximumPeakRatio(Population pop) {
        return AbstractMultiModalProblemKnown.getMaximumPeakRatioMinimization(this.listOfOptima, pop, this.getDefaultAccuracy(), 0, 5.0);
    }

    @Override
    public int getNumberOfFoundOptima(Population pop) {
        return AbstractMultiModalProblemKnown.getNoFoundOptimaOf(this, pop);
    }

    @Override
    public Population getRealOptima() {
        return this.listOfOptima;
    }

    @Override
    public String[] getAdditionalDataHeader() {
        String[] superHd = super.getAdditionalDataHeader();
        return ToolBox.appendArrays(new String[]{"numOptimaFound", "maxPeakRatio"}, new String[][]{superHd});
    }

    @Override
    public final String[] getAdditionalDataInfo() {
        String[] superHd = super.getAdditionalDataInfo();
        return ToolBox.appendArrays(new String[]{"The number of optima found", "Ratio of maximum peaks"}, new String[][]{superHd});
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        Object[] myRet = new Object[]{this.getNumberOfFoundOptima((Population)pop), this.getMaximumPeakRatio((Population)pop)};
        return ToolBox.appendArrays(myRet, new Object[][]{super.getAdditionalDataValue(pop)});
    }

    @Override
    public void initListOfOptima() {
        if (this.listOfOptimaNeedsUpdate()) {
            stateInitializingOptima = true;
            this.listOfOptima = new Population();
            double[] pos = new double[this.getProblemDimension()];
            Arrays.fill(pos, this.getXOffset());
            this.addOptimum(pos);
            double refinedX = 0.0;
            if (this.getProblemDimension() < 18) {
                for (int i = 0; i < this.getProblemDimension(); ++i) {
                    for (int k = -1; k <= 1; k += 2) {
                        Arrays.fill(pos, this.getXOffset());
                        if (refinedX == 0.0) {
                            pos[i] = (double)k + this.getXOffset();
                            double[] dir = (double[])pos.clone();
                            int n = i;
                            dir[n] = dir[n] - 0.05;
                            pos = this.inverseRotateMaybe(pos);
                            if (EuclideanMetric.euclideanDistance(pos = this.refineSolution(this, pos, dir = this.inverseRotateMaybe(dir), 5.0E-4, 1.0E-20, 0), this.listOfOptima.getEAIndividual(0).getDoublePosition()) < 0.5) {
                                System.err.println("Warning, possibly converged to a wrong optimum in F8Problem.initListOfOptima!");
                            }
                            pos = this.rotateMaybe(pos);
                            refinedX = Math.abs(pos[i] - this.getXOffset());
                        } else {
                            pos[i] = (double)k * refinedX + this.getXOffset();
                        }
                        this.addOptimum(pos);
                    }
                }
            }
            stateInitializingOptima = false;
        }
    }

    private double[] refineSolution(AbstractProblemDouble prob, double[] pos, double[] vect, double initStep, double thresh, int fitCrit) {
        double[] tmpP = (double[])pos.clone();
        double[] normedVect = Mathematics.normVect(vect);
        double dx = initStep;
        double oldFit = prob.evaluate(pos)[fitCrit];
        int dir = 1;
        while (dx > thresh) {
            Mathematics.svvAddScaled(dx * (double)dir, normedVect, pos, tmpP);
            double tmpFit = prob.evaluate(tmpP)[fitCrit];
            if (tmpFit < oldFit) {
                double[] tmp = pos;
                pos = tmpP;
                tmpP = tmp;
                oldFit = tmpFit;
                continue;
            }
            dx *= 0.73;
            dir *= -1;
        }
        return pos;
    }

    private boolean listOfOptimaNeedsUpdate() {
        if (stateInitializingOptima) {
            return false;
        }
        if (this.listOfOptima == null || this.listOfOptima.size() != 1 + 2 * this.getProblemDimension()) {
            return true;
        }
        AbstractEAIndividual indy = this.listOfOptima.getEAIndividual(1);
        double[] curFit = this.evaluate(indy.getDoublePosition());
        return Math.abs(Mathematics.dist(curFit, indy.getFitness(), 2)) > 1.0E-10;
    }

    private void addOptimum(double[] pos) {
        AbstractProblemDouble.addUnrotatedOptimum(this.listOfOptima, this, pos);
    }
}

