/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.problems.AbstractProblemDoubleOffset;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Weighted Sphere Model")
public class F9Problem
extends AbstractProblemDoubleOffset
implements Serializable {
    public F9Problem() {
        this.template = new ESIndividualDoubleData();
    }

    public F9Problem(F9Problem b) {
        super(b);
    }

    @Override
    public Object clone() {
        return new F9Problem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[]{this.yOffset};
        for (int i = 0; i < x.length; ++i) {
            result[0] = result[0] + (double)(i + 1) * Math.pow(x[i] - this.xOffset, 2.0);
        }
        return result;
    }

    public String getStringRepresentationForProblem() {
        String result = "";
        result = result + "F9 Weighted Sphere Model:\n";
        result = result + "Parameters:\n";
        result = result + "Dimension   : " + this.problemDimension + "\n";
        result = result + "Noise level : " + this.getNoise() + "\n";
        result = result + "Solution representation:\n";
        return result;
    }

    @Override
    public String getName() {
        return "Weighted Sphere";
    }
}

