/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.gui.JEFrame;
import eva2.gui.StandaloneOptimization;
import eva2.optimization.OptimizationParameters;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.InterfaceHasSolutionViewer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.problems.InterfaceSolutionViewer;
import eva2.problems.MyLensViewer;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

@Description(value="Focusing of a lens is to be optimized.")
public class FLensProblem
extends AbstractOptimizationProblem
implements InterfaceOptimizationProblem,
InterfaceHasSolutionViewer,
Serializable {
    private static final long serialVersionUID = 4694920294291719310L;
    protected AbstractEAIndividual overallBest = null;
    protected double noise = 0.0;
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;
    protected transient boolean show = false;
    private transient JEFrame problemFrame;
    private transient MyLensViewer lensViewerPanel;
    public double radius = 5.0;
    public double focalLength = 20.0;
    public double epsilon = 1.5;
    private boolean useMaterialConst = false;

    public FLensProblem() {
        this.template = new ESIndividualDoubleData();
        if (this.show) {
            this.initProblemFrame();
        }
    }

    public FLensProblem(FLensProblem b) {
        if (b.template != null) {
            this.template = (AbstractEAIndividual)b.template.clone();
        }
        if (b.overallBest != null) {
            this.overallBest = (AbstractEAIndividual)b.overallBest.clone();
        }
        this.problemDimension = b.problemDimension;
        this.noise = b.noise;
        this.xOffset = b.xOffset;
        this.yOffset = b.yOffset;
        this.radius = b.radius;
        this.focalLength = b.focalLength;
        this.epsilon = b.epsilon;
        this.useMaterialConst = b.useMaterialConst;
    }

    @Override
    public Object clone() {
        return new FLensProblem(this);
    }

    public void initProblemFrame() {
        if (this.problemFrame == null) {
            this.problemFrame = new JEFrame("Lens Problem Viewer");
            this.lensViewerPanel = new MyLensViewer(this);
            this.problemFrame.getContentPane().add(this.lensViewerPanel);
            this.problemFrame.pack();
            this.problemFrame.setVisible(true);
        } else {
            this.lensViewerPanel.resetView();
        }
    }

    public void disposeProblemFrame() {
        if (this.problemFrame != null) {
            this.problemFrame.dispose();
        }
        this.problemFrame = null;
        this.lensViewerPanel = null;
    }

    public void updateProblemFrame(Population population) {
        if (this.lensViewerPanel != null) {
            this.lensViewerPanel.updateView(population, false);
        }
    }

    @Override
    public void initializeProblem() {
        this.overallBest = null;
        if (this.show) {
            this.initProblemFrame();
        }
    }

    @Override
    public void initializePopulation(Population population) {
        this.overallBest = null;
        ((InterfaceDataTypeDouble)((Object)this.template)).setDoubleDataLength(this.problemDimension);
        double[][] range = new double[this.problemDimension][2];
        for (int i = 0; i < range.length; ++i) {
            range[i][0] = 0.1;
            range[i][1] = 5.0;
        }
        ((InterfaceDataTypeDouble)((Object)this.template)).setDoubleRange(range);
        AbstractOptimizationProblem.defaultInitializePopulation(population, this.template, this);
        if (this.show) {
            this.initProblemFrame();
        }
    }

    @Override
    public void evaluatePopulationEnd(Population pop) {
        if (this.show) {
            this.updateProblemFrame(pop);
        }
    }

    @Override
    public void evaluate(AbstractEAIndividual individual) {
        double[] x = new double[((InterfaceDataTypeDouble)((Object)individual)).getDoubleData().length];
        System.arraycopy(((InterfaceDataTypeDouble)((Object)individual)).getDoubleData(), 0, x, 0, x.length);
        int i = 0;
        while (i < x.length) {
            int n = i++;
            x[n] = x[n] - this.xOffset;
        }
        double[] fitness = this.doEvaluation(x);
        for (i = 0; i < fitness.length; ++i) {
            int n = i;
            fitness[n] = fitness[n] + RNG.gaussianDouble(this.noise);
            int n2 = i;
            fitness[n2] = fitness[n2] + this.yOffset;
            individual.SetFitness(i, fitness[i]);
        }
        if (this.overallBest == null || this.overallBest.getFitness(0) > individual.getFitness(0)) {
            this.overallBest = (AbstractEAIndividual)individual.clone();
        }
    }

    public double[] doEvaluation(double[] x) {
        double fitness = 0.0;
        double[] ret = new double[1];
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] < 0.1)) continue;
            x[i] = 0.1;
        }
        double[] tmpFit = this.testLens(x);
        for (int i = 0; i < tmpFit.length; ++i) {
            fitness += Math.pow(tmpFit[i], 2.0);
        }
        if (this.useMaterialConst) {
            fitness += x[x.length / 2];
        }
        ret[0] = fitness;
        return ret;
    }

    public double[] testLens(double[] x) {
        double segmentHeight = 2.0 * this.radius / (double)(x.length - 1);
        double[] result = new double[x.length - 1];
        for (int i = 1; i < x.length; ++i) {
            result[i - 1] = this.radius - segmentHeight / 2.0 - segmentHeight * (double)(i - 1) - this.focalLength / segmentHeight * (this.epsilon - 1.0) * (x[i] - x[i - 1]);
        }
        return result;
    }

    @Override
    public String getSolutionRepresentationFor(AbstractEAIndividual individual) {
        this.evaluate(individual);
        String result = "FX problem:\n";
        result = result + individual.getStringRepresentation() + "\n";
        result = result + "Y = " + individual.getFitness(0);
        return result;
    }

    public String getFinalReportOn(InterfaceOptimizer optimizer) {
        String result = optimizer.getStringRepresentation() + "\n";
        result = result + this.getSolutionRepresentationFor(this.overallBest);
        return result;
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        String result = "";
        result = result + "FX Problem:\n";
        result = result + "Here the individual codes a vector of real number x and FX(x)= x is to be minimized.\n";
        result = result + "Parameters:\n";
        result = result + "Dimension   : " + this.problemDimension + "\n";
        result = result + "Noise level : " + this.noise + "\n";
        result = result + "Solution representation:\n";
        return result;
    }

    @Override
    public JComponent drawIndividual(AbstractEAIndividual indy) {
        JTextArea tindy = new JTextArea(indy.getStringRepresentation());
        JScrollPane pindy = new JScrollPane(tindy);
        tindy.setEditable(false);
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        result.add((Component)tindy, "North");
        result.add((Component)pindy, "Center");
        return result;
    }

    public static void main(String[] args) {
        System.out.println("TEST");
        FLensProblem f = new FLensProblem();
        System.out.println("Working Dir " + System.getProperty("user.dir"));
        StandaloneOptimization program = new StandaloneOptimization();
        OptimizationParameters GO = program.getGOParameters();
        GO.setProblem(f);
        RNG.setRandomSeed(1L);
        program.initFrame();
        program.setShow(true);
    }

    @Override
    public String getName() {
        return "Lens Problem";
    }

    public void setNoise(double noise) {
        if (noise < 0.0) {
            noise = 0.0;
        }
        this.noise = noise;
    }

    public double getNoise() {
        return this.noise;
    }

    public String noiseTipText() {
        return "Noise level on the fitness value.";
    }

    public void setXOffSet(double XOffSet) {
        this.xOffset = XOffSet;
    }

    public double getXOffSet() {
        return this.xOffset;
    }

    public String xOffSetTipText() {
        return "Choose an offset for the decision variable.";
    }

    public void setYOffSet(double YOffSet) {
        this.yOffset = YOffSet;
    }

    public double getYOffSet() {
        return this.yOffset;
    }

    public String yOffSetTipText() {
        return "Choose an offset for the objective value.";
    }

    public void setShow(boolean show) {
        this.show = show;
        if (this.show) {
            this.initProblemFrame();
        } else {
            this.disposeProblemFrame();
        }
    }

    public boolean getShow() {
        return this.show;
    }

    public String showTipText() {
        return "Toggle the visualization of the solution.";
    }

    public void setUseMaterialConst(boolean show) {
        this.useMaterialConst = show;
    }

    public boolean getUseMaterialConst() {
        return this.useMaterialConst;
    }

    public String useMaterialConstTipText() {
        return "Toggle the use of the material constraint.";
    }

    public void setEAIndividual(InterfaceDataTypeDouble indy) {
        this.template = (AbstractEAIndividual)((Object)indy);
    }

    public InterfaceDataTypeDouble getEAIndividual() {
        return (InterfaceDataTypeDouble)((Object)this.template);
    }

    public void setEAIndividualTrap(AbstractEAIndividual indy) {
        if (indy instanceof InterfaceDataTypeDouble) {
            this.setEAIndividual((InterfaceDataTypeDouble)((Object)indy));
        }
    }

    @Override
    public InterfaceSolutionViewer getSolutionViewer() {
        return this.lensViewerPanel;
    }
}

