/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.problems.AbstractMultiModalProblemKnown;
import eva2.problems.Interface2DBorderProblem;
import eva2.problems.InterfaceMultimodalProblemKnown;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="M0(x) = sin(2*x - 0.5*PI) + 1 + 2*cos(y) + 0.5*x is to be maximized, two optima.")
public class FM0Problem
extends AbstractMultiModalProblemKnown
implements InterfaceOptimizationProblem,
Interface2DBorderProblem,
InterfaceMultimodalProblemKnown,
Serializable {
    public FM0Problem() {
        this.problemDimension = 2;
        this.template = new ESIndividualDoubleData();
    }

    @Override
    public double getRangeUpperBound(int dim) {
        if (dim == 0) {
            return 2.0;
        }
        return 2.8;
    }

    @Override
    public double getRangeLowerBound(int dim) {
        return -1.0 * this.getRangeUpperBound(dim);
    }

    public FM0Problem(FM0Problem b) {
        this.cloneObjects(b);
    }

    @Override
    public Object clone() {
        return new FM0Problem(this);
    }

    @Override
    public double[] evalUnnormalized(double[] x) {
        double[] result = new double[]{Math.sin(2.0 * x[0] - 1.5707963267948966) + 1.0 + 2.0 * Math.cos(x[1]) + 0.5 * x[0]};
        return result;
    }

    @Override
    public void initListOfOptima() {
        this.add2DOptimum(1.6971364585239, -8.96995E-9);
        this.add2DOptimum(-1.44445618316078, 7.00284E-9);
    }

    @Override
    public String getName() {
        return "M0 Problem";
    }
}

