/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.codings.gp.GPArea;
import eva2.optimization.individuals.codings.gp.InterfaceProgram;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractProblemDouble;
import eva2.problems.InterfaceProgramProblem;
import eva2.problems.PSymbolicRegression;
import eva2.tools.EVAERROR;

public class GPFunctionProblem
extends AbstractProblemDouble
implements InterfaceProgramProblem {
    InterfaceProgram gpProblem = null;
    GPArea gpArea = new GPArea();
    double[] pos = null;
    int problemDimension = 2;
    double scalingStart = 10.0;
    double scalingLimit = 20.0;
    public static boolean hideFromGOE = true;

    public GPFunctionProblem(InterfaceProgram gpProb, GPArea area) {
        this(gpProb, area, 0.0, 0.0);
    }

    public GPFunctionProblem(InterfaceProgram gpProb, GPArea area, double scStart, double scLim) {
        this(gpProb, area, 2, scStart, scLim);
    }

    public GPFunctionProblem(InterfaceProgram gpProb, GPArea area, int pDim, double scStart, double scLim) {
        this.problemDimension = pDim;
        ((ESIndividualDoubleData)this.template).setDoubleDataLength(this.problemDimension);
        this.gpProblem = gpProb;
        this.gpArea = area;
        this.scalingStart = scStart;
        this.scalingLimit = scLim;
    }

    public GPFunctionProblem(GPFunctionProblem functionProblem) {
        this.problemDimension = functionProblem.problemDimension;
        if (functionProblem.pos != null) {
            this.pos = new double[this.problemDimension];
            System.arraycopy(functionProblem.pos, 0, this.pos, 0, this.problemDimension);
        }
        this.gpArea = (GPArea)functionProblem.gpArea.clone();
        this.gpProblem = functionProblem.gpProblem;
    }

    @Override
    public Object clone() {
        return new GPFunctionProblem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        if (x.length != this.problemDimension) {
            EVAERROR.errorMsgOnce("mismatching dimension of GPFunctionProblem! Setting to " + x.length);
            this.setProblemDimension(x.length);
        }
        x = this.rotateMaybe(x);
        this.pos = x;
        Double res = (Double)this.gpProblem.evaluate(this);
        double[] fit = new double[]{this.scaleFit(res)};
        return fit;
    }

    @Override
    public void setProblemDimension(int newDim) {
        this.problemDimension = newDim;
        ((ESIndividualDoubleData)this.template).setDoubleDataLength(this.problemDimension);
    }

    public double scaleFit(double v) {
        if (this.scalingLimit == 0.0) {
            return v;
        }
        double aV = Math.abs(v);
        if (aV > this.scalingStart) {
            double logVal = Math.log(aV) / Math.log(this.scalingStart);
            double tmp = 1.0 / logVal;
            return (this.scalingLimit - tmp) * Math.signum(v);
        }
        return v;
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        return "GP find a function problem";
    }

    @Override
    public Object getSensorValue(String sensor) {
        return PSymbolicRegression.getSensorValue(sensor, this.pos, null);
    }

    @Override
    public void setActuatorValue(String actuator, Object parameter) {
    }

    @Override
    public GPArea getArea() {
        return this.gpArea;
    }
}

