/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractProblemInteger;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="A hyper parabola on integer values x with I1(x) = x^2 is to be minimized.")
public class I1Problem
extends AbstractProblemInteger
implements Serializable {
    public I1Problem() {
    }

    public I1Problem(I1Problem o) {
        super.cloneObjects(o);
    }

    @Override
    public Object clone() {
        return new I1Problem(this);
    }

    @Override
    public double[] evaluate(int[] x) {
        double[] result = new double[]{0.0};
        for (int i = 0; i < x.length; ++i) {
            result[0] = result[0] + Math.pow(x[i], 2.0);
        }
        result[0] = result[0] + 1.0;
        return result;
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        String result = "";
        result = result + "I1 Problem:\n";
        result = result + "Here the individual codes a vector of int numbers x and F1(x)= x^2 is to be minimized.\n";
        result = result + "Parameters:\n";
        result = result + "Dimension   : " + this.problemDimension + "\n";
        result = result + "Solution representation:\n";
        return result;
    }

    @Override
    public String getName() {
        return "I1 Problem";
    }
}

