/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.gui.BeanInspector;
import eva2.problems.MatlabProblem;
import java.util.BitSet;
import java.util.concurrent.Semaphore;

public class MatlabEvalMediator {
    volatile Boolean requesting = false;
    private volatile Boolean fin = false;
    volatile Object question = null;
    volatile double[] answer = null;
    volatile boolean quit = false;
    volatile Object optSolution = null;
    volatile Object[] optSolSet = null;
    volatile Semaphore requests;
    int runID = -1;
    volatile MatlabProblem mp = null;
    private int sleepTime = 5;

    public MatlabEvalMediator(int threadSleepTime) {
        this.sleepTime = threadSleepTime;
        this.requests = new Semaphore(0);
    }

    public MatlabEvalMediator() {
        this.sleepTime = 0;
        this.requests = new Semaphore(0);
    }

    public void setMatlabProblem(MatlabProblem theMP) {
        this.mp = theMP;
        this.logMP("setting MP " + theMP + " for MEM " + this + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double[] requestEval(MatlabProblem mp, Object x) {
        this.mp = mp;
        this.question = x;
        if (this.question.getClass().isArray()) {
            if (this.question == null) {
                System.err.println("Error: requesting evaluation for null array!");
            }
        } else if (!(x instanceof BitSet)) {
            System.err.println("Error, requesting evaluation for invalid data type! " + this.question.getClass());
        }
        Boolean bl = this.requesting;
        synchronized (bl) {
            if (this.requesting.booleanValue()) {
                String msg = "Warning: already in requesting state when request arrived!";
                System.err.println(msg);
                this.logMP(msg);
            }
            this.requesting = true;
        }
        try {
            this.requests.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.logMP("-- Requesting done\n");
        return this.getAnswer();
    }

    public String getState() {
        return "ID: " + this.runID + ", qu: " + BeanInspector.toString(this.question) + " quit,fin,req " + this.quit + "," + this.fin + "," + this.requesting;
    }

    public void run(int id) {
        this.logMPOrSysOut("## MEM start run " + id);
        this.runID = id;
        int k = 0;
        int mod = 25;
        while (!(this.requesting.booleanValue() || this.isFinished() || this.quit)) {
            if (this.sleepTime > 0) {
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (++k % mod != 0) continue;
            this.logMPOrSysOut("MEM waiting for JE to ask... (" + mod + ") " + this.getState());
            if ((mod *= 2) > 0) continue;
            mod = Integer.MAX_VALUE;
        }
        if (this.requesting.booleanValue()) {
            this.logMPOrSysOut("-- MEM Request arrived in MP thread " + this.runID);
        } else {
            this.logMPOrSysOut("-- MEM finished or quit " + this.runID);
        }
    }

    public void run() {
        this.run(0);
    }

    private void logMPOrSysOut(String msg) {
        this.logMP(msg);
    }

    private void logMP(String msg) {
        if (this.mp != null) {
            this.mp.log(msg + "\n");
        }
    }

    public void quit() {
        this.quit = true;
    }

    public Object getQuestion() {
        if (this.mp != null) {
            this.logMP("-- Question: " + BeanInspector.toString(this.question) + "\n");
        }
        return this.question;
    }

    double[] getAnswer() {
        if (this.mp != null) {
            this.logMP("-- mediator delivering " + BeanInspector.toString(this.answer) + "\n");
        }
        return this.answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnswer(double[] y) {
        Boolean bl = this.requesting;
        synchronized (bl) {
            if (!this.requesting.booleanValue()) {
                String msg = "Error: not in requesting state when answer arrived!!";
                System.err.println(msg);
                this.logMP(msg);
            }
            if (y == null) {
                System.err.println("Error: Matlab function returned null array - this is bad.");
                System.err.println("X-value was " + BeanInspector.toString(this.getQuestion()));
            }
            this.answer = y;
            this.requesting = false;
            this.requests.release();
            this.logMP("-- setAnswer: " + BeanInspector.toString(y) + ", req state is " + this.requesting + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFinished(boolean val) {
        Boolean bl = this.fin;
        synchronized (bl) {
            if (this.fin.booleanValue() && val) {
                String msg = "Error: already finished when setFinished(true) was called!";
                System.err.println(msg);
                this.logMP(msg);
            }
            this.fin = val;
            this.logMPOrSysOut("MEM setFinished ok");
        }
    }

    public boolean isFinished() {
        return this.fin;
    }

    void setSolution(Object sol) {
        this.optSolution = sol;
    }

    void setSolutionSet(double[][] solSet) {
        this.optSolSet = (Object[])solSet;
    }

    void setSolutionSet(BitSet[] solSet) {
        this.optSolSet = solSet;
    }

    void setSolutionSet(int[][] solSet) {
        this.optSolSet = (Object[])solSet;
    }

    public Object getSolution() {
        return this.optSolution;
    }

    public Object getSolutionSet() {
        return this.optSolSet;
    }
}

