/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.OptimizerFactory;
import eva2.OptimizerRunnable;
import eva2.gui.BeanInspector;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.GAIndividualBinaryData;
import eva2.optimization.individuals.GIIndividualIntegerData;
import eva2.optimization.individuals.InterfaceDataTypeBinary;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.individuals.InterfaceDataTypeInteger;
import eva2.optimization.operator.postprocess.InterfacePostProcessParams;
import eva2.optimization.operator.postprocess.PostProcess;
import eva2.optimization.operator.postprocess.PostProcessParams;
import eva2.optimization.operator.terminators.FitnessConvergenceTerminator;
import eva2.optimization.operator.terminators.PhenotypeConvergenceTerminator;
import eva2.optimization.operator.terminators.PopulationMeasureTerminator;
import eva2.optimization.population.Population;
import eva2.optimization.statistics.InterfaceStatisticsParameters;
import eva2.optimization.statistics.InterfaceTextListener;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.InterfaceHasInitRange;
import eva2.problems.MatlabEvalMediator;
import eva2.problems.MatlabProblemDataTypeEnum;
import eva2.problems.WaitForEvARunnable;
import eva2.util.annotation.Description;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;

@Description(value="Interface problem class for optimization in Matlab, only usable from within Matlab")
public class MatlabProblem
extends AbstractOptimizationProblem
implements InterfaceHasInitRange,
InterfaceTextListener,
Serializable {
    private static final long serialVersionUID = 4913310869887420815L;
    transient OptimizerRunnable runnable = null;
    protected boolean allowSingleRunnable = true;
    private transient Population seedPopulation = null;
    protected int problemDimension = 10;
    transient PrintStream dos = null;
    private double[][] range = null;
    private static String defTestOut = "matlabproblem-debug.log";
    InterfaceStatisticsParameters.OutputVerbosity verbosityLevel = InterfaceStatisticsParameters.OutputVerbosity.NONE;
    boolean outputAllStatsField = true;
    private MatlabEvalMediator handler = null;
    private MatlabProblemDataTypeEnum dataType = MatlabProblemDataTypeEnum.typeDouble;
    private double[][] initialRange = null;
    public static boolean hideFromGOE = true;

    public MatlabProblem(MatlabProblem o) {
        this.template = null;
        this.handler = o.handler;
        this.runnable = o.runnable;
        this.allowSingleRunnable = o.allowSingleRunnable;
        this.problemDimension = o.problemDimension;
        this.range = o.range;
        this.dataType = o.dataType;
        this.initialRange = o.initialRange;
    }

    @Override
    public Object clone() {
        return new MatlabProblem(this);
    }

    public MatlabProblem(int dim) {
        this.init(dim, MatlabProblemDataTypeEnum.typeBinary, null, null, defTestOut);
    }

    public MatlabProblem(int dim, MatlabProblemDataTypeEnum datType, double[][] range) {
        this.init(dim, datType, range, null, defTestOut);
    }

    public MatlabProblem(int dim, MatlabProblemDataTypeEnum datType, double[][] range, double[][] initRange) {
        this.init(dim, datType, range, initRange, defTestOut);
    }

    protected void initTemplate() {
        switch (this.dataType) {
            case typeDouble: {
                if (this.template == null || !(this.template instanceof ESIndividualDoubleData)) {
                    this.template = new ESIndividualDoubleData();
                }
                if (this.getProblemDimension() <= 0) break;
                ((InterfaceDataTypeDouble)((Object)this.template)).setDoubleDataLength(this.getProblemDimension());
                ((InterfaceDataTypeDouble)((Object)this.template)).setDoubleRange(this.range);
                break;
            }
            case typeBinary: {
                if (this.template != null && this.template instanceof GAIndividualBinaryData) break;
                this.template = new GAIndividualBinaryData(this.getProblemDimension());
                break;
            }
            case typeInteger: {
                int[][] intRange = this.makeIntRange(this.range);
                if (this.template != null && this.template instanceof GIIndividualIntegerData) break;
                this.template = new GIIndividualIntegerData(intRange);
            }
        }
    }

    private int[][] makeIntRange(double[][] r) {
        int[][] intRange = new int[r.length][r[0].length];
        for (int i = 0; i < r.length; ++i) {
            for (int j = 0; j < r[0].length; ++j) {
                intRange[i][j] = (int)r[i][j];
            }
        }
        return intRange;
    }

    public void setMediator(MatlabEvalMediator h) {
        this.handler = h;
        this.handler.setMatlabProblem(this);
    }

    @Override
    public void initializeProblem() {
        this.init(this.problemDimension, this.dataType, this.range, this.initialRange, defTestOut);
    }

    public static FitnessConvergenceTerminator makeFitConvTerm(double thresh, int stagnPeriod) {
        FitnessConvergenceTerminator fct = new FitnessConvergenceTerminator(thresh, stagnPeriod, PopulationMeasureTerminator.StagnationTypeEnum.fitnessCallBased, PopulationMeasureTerminator.ChangeTypeEnum.absoluteChange, PopulationMeasureTerminator.DirectionTypeEnum.decrease);
        return fct;
    }

    public static PhenotypeConvergenceTerminator makePhenConvTerm(double thresh, int stagnPeriod) {
        PhenotypeConvergenceTerminator pct = new PhenotypeConvergenceTerminator(thresh, stagnPeriod, PopulationMeasureTerminator.StagnationTypeEnum.fitnessCallBased, PopulationMeasureTerminator.ChangeTypeEnum.absoluteChange, PopulationMeasureTerminator.DirectionTypeEnum.decrease);
        return pct;
    }

    private void init(int dim, MatlabProblemDataTypeEnum datType, double[][] globalRange, double[][] initRange, String outFile) {
        int i;
        this.problemDimension = dim;
        if (globalRange != null) {
            this.range = new double[globalRange.length][globalRange[0].length];
            for (i = 0; i < this.range.length; ++i) {
                System.arraycopy(globalRange[i], 0, this.range[i], 0, this.range[0].length);
            }
        } else {
            this.range = null;
        }
        if (initRange != null) {
            this.initialRange = new double[initRange.length][initRange[0].length];
            for (i = 0; i < this.initialRange.length; ++i) {
                System.arraycopy(initRange[i], 0, this.initialRange[i], 0, this.initialRange[0].length);
            }
        } else {
            this.initialRange = null;
        }
        if (Arrays.deepEquals((Object[])this.initialRange, (Object[])this.range)) {
            this.initialRange = null;
        }
        this.dataType = datType;
        this.log("### Data type is " + (Object)((Object)this.dataType));
        this.initTemplate();
        this.log("Initial range is " + BeanInspector.toString(this.initialRange) + "\n");
    }

    public void setDebugOut(boolean swtch, String fname) {
        if (!swtch && this.dos != null) {
            this.dos.close();
            this.dos = null;
        } else if (swtch && this.dos == null) {
            try {
                if (fname == null || fname.length() == 0) {
                    fname = defTestOut;
                }
                this.dos = new PrintStream(new FileOutputStream(fname));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public String jmiInterfaceNameTipText() {
        return "Name of the JEInterface instance in Matlab";
    }

    @Override
    public void setProblemDimension(int problemDimension) {
        this.problemDimension = problemDimension;
    }

    public void log(String str) {
        if (this.dos != null) {
            this.dos.print(str);
            this.dos.flush();
        }
    }

    public void optimize(int optType, String outputFilePrefix) {
        this.optimize(optType, outputFilePrefix, null, null);
    }

    public void clearSeedPopulation() {
        this.seedPopulation = null;
    }

    public void setSeedPopulation(double[][] seedData, double[][] seedDataFit) {
        if (seedData == null) {
            this.seedPopulation = null;
        } else if (seedData.length != seedDataFit.length || seedData[0].length != this.getProblemDimension()) {
            System.err.println("Error, unable to set seed population due to mismatching dimensions");
            this.seedPopulation = null;
        } else {
            this.log("Setting seed population of size " + seedData.length + "\n");
            this.seedPopulation = new Population(seedData.length);
            for (int i = 0; i < seedData.length; ++i) {
                AbstractEAIndividual indy = (AbstractEAIndividual)this.template.clone();
                this.setIndyGenotype(indy, seedData[i]);
                indy.setFitness(seedDataFit[i]);
                this.seedPopulation.add(indy);
            }
        }
    }

    private void setIndyGenotype(AbstractEAIndividual indy, double[] ds) {
        switch (this.dataType) {
            case typeDouble: {
                ((InterfaceDataTypeDouble)((Object)indy)).setDoubleGenotype(ds);
                break;
            }
            case typeBinary: {
                ((InterfaceDataTypeBinary)((Object)indy)).setBinaryGenotype(this.toBinary(ds));
                break;
            }
            case typeInteger: {
                ((InterfaceDataTypeInteger)((Object)indy)).setIntGenotype(this.toInteger(ds));
            }
        }
    }

    private int[] toInteger(double[] ds) {
        int[] a = new int[ds.length];
        for (int i = 0; i < ds.length; ++i) {
            a[i] = (int)Math.round(ds[i]);
        }
        return a;
    }

    private BitSet toBinary(double[] ds) {
        BitSet bs = new BitSet(ds.length);
        for (int i = 0; i < ds.length; ++i) {
            bs.set(i, ds[i] > 0.5);
        }
        return bs;
    }

    public void optimize(int optType, String outputFilePrefix, Object[] specParams, Object[] specValues) {
        if (this.allowSingleRunnable && this.runnable != null && !this.runnable.isFinished()) {
            System.err.println("Please wait for the current optimization to finish");
        } else {
            this.handler.setMatlabProblem(this);
            this.handler.setFinished(false);
            this.runnable = OptimizerFactory.getOptRunnable(optType, this, outputFilePrefix);
            this.log("in MP optimize B\n");
            this.log("Setting text listener, verbo " + (Object)((Object)this.verbosityLevel) + "\n");
            this.runnable.setTextListener(this);
            this.runnable.setVerbosityLevel(this.verbosityLevel);
            if (this.verbosityLevel != InterfaceStatisticsParameters.OutputVerbosity.NONE) {
                this.runnable.setOutputTo(InterfaceStatisticsParameters.OutputTo.BOTH);
            } else {
                this.runnable.setOutputTo(InterfaceStatisticsParameters.OutputTo.WINDOW);
            }
            this.runnable.setOutputFullStatsToText(this.outputAllStatsField);
            if (this.seedPopulation != null) {
                this.runnable.getOptimizationParameters().getOptimizer().setPopulation(this.seedPopulation);
                this.runnable.setDoRestart(true);
                this.log("Setting seed population of size " + this.seedPopulation.size() + ", target size " + this.seedPopulation.getTargetSize() + "\n");
                this.log(BeanInspector.toString(this.seedPopulation.getStringRepresentation()) + "\n");
                this.log("Restart of optimization targetted.\n");
            }
            if (specParams != null && specParams.length > 0) {
                if (specValues == null || specValues.length != specParams.length) {
                    System.err.println("mismatching value list for parameter arguments: " + specValues);
                } else {
                    this.log("setting specific parameters...\n");
                    InterfaceOptimizer opt = this.runnable.getOptimizationParameters().getOptimizer();
                    for (int i = 0; i < specParams.length; ++i) {
                        String paramName;
                        block12: {
                            this.log("try setting " + specParams[i] + " to " + specValues[i]);
                            paramName = null;
                            try {
                                paramName = (String)specParams[i];
                            }
                            catch (ClassCastException e) {
                                paramName = "" + specParams[i];
                                if (specParams[i] instanceof Character) break block12;
                                System.err.println("Error, parameter " + specParams[i] + " could not be cast to String, trying " + paramName);
                            }
                        }
                        Object specVal = null;
                        specVal = specValues[i] instanceof Character ? "" + specValues[i] : specValues[i];
                        if (paramName == null || !BeanInspector.setMem(opt, paramName, specVal)) {
                            this.log("... Fail!\n");
                            System.err.println("Unable to set parameter " + paramName + ", skipping...");
                            continue;
                        }
                        this.log("... Ok.\n");
                    }
                    this.log(BeanInspector.toString(BeanInspector.getMemberDescriptions(opt, true)));
                }
            }
            new Thread(new WaitForEvARunnable(this.runnable, this)).start();
        }
    }

    public void setOutputAllStatFields(boolean showAll) {
        this.outputAllStatsField = showAll;
    }

    public void startPostProcess(InterfacePostProcessParams ppp) {
        if (ppp.isDoPostProcessing()) {
            if (this.allowSingleRunnable && this.runnable != null && !this.runnable.isFinished()) {
                System.err.println("Please wait for the current optimization to finish");
            } else {
                this.handler.setFinished(false);
                this.log("\nstarting post process thread... " + BeanInspector.toString(ppp));
                this.runnable.setDoRestart(true);
                this.runnable.setDoPostProcessOnly(true);
                this.runnable.setPostProcessingParams(ppp);
                new Thread(new WaitForEvARunnable(this.runnable, this)).start();
            }
        } else {
            System.err.println("Nothing to be done.");
        }
    }

    public void requestPostProcessing(int steps, double sigma, int nBest) {
        PostProcessParams ppp = new PostProcessParams(steps, sigma, nBest);
        this.startPostProcess(ppp);
    }

    public void requestPostProcessing(int steps, double sigma) {
        this.requestPostProcessing(steps, sigma, -1);
    }

    public void stopOptimize() {
        this.log(">>>>>>>>>> Stop event!\n");
        if (this.runnable != null) {
            this.runnable.stopOpt();
        }
        PostProcess.stopAllPP();
    }

    public String getInfoString() {
        if (this.runnable == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("");
        sb.append(this.runnable.terminatedBecause());
        return sb.toString();
    }

    public int getFunctionCalls() {
        if (this.runnable == null) {
            return 0;
        }
        return this.runnable.getOptimizationParameters().getOptimizer().getPopulation().getFunctionCalls();
    }

    void exportResultPopulationToMatlab(Population pop) {
        if (pop != null && pop.size() > 0) {
            switch (this.dataType) {
                case typeDouble: {
                    double[][] rsolSet = new double[pop.size()][];
                    for (int i = 0; i < pop.size(); ++i) {
                        rsolSet[i] = ((InterfaceDataTypeDouble)((Object)pop.getEAIndividual(i))).getDoubleData();
                    }
                    this.handler.setSolutionSet(rsolSet);
                    break;
                }
                case typeBinary: {
                    BitSet[] bsolSet = new BitSet[pop.size()];
                    for (int i = 0; i < pop.size(); ++i) {
                        bsolSet[i] = ((InterfaceDataTypeBinary)((Object)pop.getEAIndividual(i))).getBinaryData();
                    }
                    this.handler.setSolutionSet(bsolSet);
                    break;
                }
                case typeInteger: {
                    int[][] isolSet = new int[pop.size()][];
                    for (int i = 0; i < pop.size(); ++i) {
                        isolSet[i] = ((InterfaceDataTypeInteger)((Object)pop.getEAIndividual(i))).getIntegerData();
                    }
                    this.handler.setSolutionSet(isolSet);
                }
            }
        } else {
            switch (this.dataType) {
                case typeDouble: {
                    this.handler.setSolutionSet((double[][])null);
                    break;
                }
                case typeBinary: {
                    this.handler.setSolutionSet((BitSet[])null);
                    break;
                }
                case typeInteger: {
                    this.handler.setSolutionSet((int[][])null);
                }
            }
        }
    }

    public void exportResultToMatlab(OptimizerRunnable runnable) {
        this.handler.setSolution(this.getIntermediateResult());
    }

    void notifyFinished() {
        this.handler.setFinished(true);
    }

    public Object getIntermediateResult() {
        if (this.runnable == null) {
            System.err.println("Warning, runnable is null in MatlabProblem!");
            return null;
        }
        switch (this.dataType) {
            case typeDouble: {
                return this.runnable.getDoubleSolution();
            }
            case typeBinary: {
                return this.runnable.getBinarySolution();
            }
            case typeInteger: {
                return this.runnable.getIntegerSolution();
            }
        }
        System.err.println("Warning, incompatible data type in MatlabProblem!");
        return null;
    }

    public int getProgress() {
        if (this.runnable == null) {
            return 0;
        }
        return this.runnable.getProgress();
    }

    @Override
    public void print(String str) {
        if (this.verbosityLevel != InterfaceStatisticsParameters.OutputVerbosity.NONE) {
            System.out.print(str);
        }
        this.log(str);
    }

    @Override
    public void println(String str) {
        this.print(str);
        this.print("\n");
    }

    @Override
    public void evaluate(AbstractEAIndividual indy) {
        this.log("evaluating " + AbstractEAIndividual.getDefaultStringRepresentation(indy) + "\n");
        double[] res = this.handler.requestEval(this, AbstractEAIndividual.getIndyData(indy));
        this.log("evaluated to " + BeanInspector.toString(res) + "\n");
        this.log("Free mem is " + Runtime.getRuntime().freeMemory() + ", time is " + System.currentTimeMillis() + "\n");
        indy.setFitness(res);
    }

    @Override
    public void initializePopulation(Population population) {
        this.initTemplate();
        AbstractOptimizationProblem.defaultInitializePopulation(population, this.template, this);
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("A general Matlab problem");
        sb.append(this.getName());
        return sb.toString();
    }

    @Override
    public Object getInitializationRange() {
        this.log("retrieving initial range..., first entry: " + (this.initialRange == null ? "null" : BeanInspector.toString(this.initialRange[0])));
        return this.initialRange;
    }

    @Override
    public String getName() {
        return "MatlabProblem";
    }
}

