/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.population.Population;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.FLensProblem;
import eva2.problems.InterfaceSolutionViewer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;

class MyLensViewer
extends JPanel
implements InterfaceSolutionViewer {
    private static final long serialVersionUID = 7945150208043416139L;
    Population indiesToPaint = new Population();
    private int theHeight;
    private int theWidth;
    FLensProblem lensProblem;

    public MyLensViewer(FLensProblem f) {
        this.initView(f);
        Dimension d = new Dimension(280, 220);
        this.setPreferredSize(d);
        this.setIgnoreRepaint(true);
        this.setMinimumSize(d);
        this.resetView();
    }

    @Override
    public void initView(AbstractOptimizationProblem prob) {
        this.lensProblem = (FLensProblem)prob;
    }

    @Override
    public void resetView() {
        ESIndividualDoubleData dummy = new ESIndividualDoubleData();
        dummy.setFitness(new double[]{Double.POSITIVE_INFINITY});
        this.indiesToPaint = new Population();
    }

    @Override
    public void paint(Graphics g) {
        BasicStroke ds = new BasicStroke();
        int mag = 10;
        BasicStroke dashStroke = new BasicStroke(ds.getLineWidth(), ds.getEndCap(), ds.getLineJoin(), ds.getMiterLimit(), new float[]{8.0f, 8.0f}, 0.0f);
        Dimension winDim = this.getSize();
        this.theHeight = winDim.height;
        this.theWidth = winDim.width;
        BufferedImage bufferedImage = new BufferedImage(this.theWidth, this.theHeight, 1);
        Graphics2D g2D = bufferedImage.createGraphics();
        super.paint(g2D);
        g2D.setPaint(Color.white);
        Rectangle tmpShape = new Rectangle(0, 0, this.theWidth, this.theHeight);
        g2D.fill(tmpShape);
        g2D.setPaint(Color.black);
        g2D.drawLine(0, this.theHeight / 2, this.theWidth, this.theHeight / 2);
        int centerLens = 55;
        int centerScreen = centerLens + (int)this.lensProblem.focalLength * 10;
        int segment = 10 * (int)this.lensProblem.radius * 2 / (this.lensProblem.problemDimension - 1);
        g2D.setStroke(dashStroke);
        g2D.drawLine(centerLens, this.theHeight / 2 + (int)this.lensProblem.radius * 10, centerLens, this.theHeight / 2 - (int)this.lensProblem.radius * 10);
        g2D.drawLine(centerScreen, this.theHeight / 2 + (int)this.lensProblem.radius * 10 + 10, centerScreen, this.theHeight / 2 - (int)this.lensProblem.radius * 10 - 10);
        g2D.setStroke(ds);
        this.paintLens(this.lensProblem.problemDimension, this.theHeight, this.lensProblem.radius, mag, centerLens, centerScreen, segment, g2D);
        g.drawImage(bufferedImage, 0, 0, this);
    }

    private void paintLens(int dim, int height, double radius, int mag, int centerLens, int centerScreen, int segment, Graphics2D g2D) {
        for (int i = 0; i < this.indiesToPaint.size(); ++i) {
            AbstractEAIndividual indy = this.indiesToPaint.getEAIndividual(i);
            MyLensViewer.paintLens(indy.getDoublePosition(), this.lensProblem.testLens(indy.getDoublePosition()), indy.getFitness(0), dim, height, radius, mag, centerLens, centerScreen, segment, g2D);
        }
    }

    private void paintLens(AbstractEAIndividual indy, int dim, int height, double radius, int mag, int centerLens, int centerScreen, int segment, Graphics2D g2D) {
        if (indy != null) {
            MyLensViewer.paintLens(indy.getDoublePosition(), this.lensProblem.testLens(indy.getDoublePosition()), indy.getFitness(0), dim, height, radius, mag, centerLens, centerScreen, segment, g2D);
        }
    }

    private static void paintLens(double[] variables, double[] dots, double fit, int dim, int height, double radius, int mag, int centerLens, int centerScreen, int segment, Graphics2D g2D) {
        g2D.drawLine(centerLens - (int)(variables[0] * (double)mag), height / 2 - (int)radius * 10, centerLens + (int)(variables[0] * (double)mag), height / 2 - (int)radius * 10);
        g2D.drawLine(centerLens - (int)(variables[dim - 1] * (double)mag), height / 2 + (int)radius * 10, centerLens + (int)(variables[dim - 1] * (double)mag), height / 2 + (int)radius * 10);
        g2D.drawString("Fitness : " + fit, (int)(variables[0] * (double)mag), 15);
        int currentXPos = height / 2 - (int)radius * 10;
        for (int i = 1; i < variables.length; ++i) {
            g2D.setPaint(Color.black);
            g2D.drawLine(centerLens - (int)(variables[i - 1] * (double)mag), currentXPos, centerLens - (int)(variables[i] * (double)mag), currentXPos + segment);
            g2D.drawLine(centerLens + (int)(variables[i - 1] * (double)mag), currentXPos, centerLens + (int)(variables[i] * (double)mag), currentXPos + segment);
            g2D.setPaint(Color.red);
            g2D.drawLine(0, currentXPos + segment / 2, centerLens, currentXPos + segment / 2);
            g2D.drawLine(centerLens, currentXPos + segment / 2, centerScreen, height / 2 + (int)(dots[i - 1] * (double)mag));
            currentXPos += segment;
        }
    }

    @Override
    public void updateView(Population pop, boolean showAllIfPossible) {
        if (showAllIfPossible) {
            for (int i = 0; i < pop.size(); ++i) {
                MyLensViewer newView = new MyLensViewer(this.lensProblem);
                Population newPop = new Population();
                newPop.add(pop.getEAIndividual(i));
                newView.updateView(newPop, false);
                JFrame newFrame = new JFrame("Lens Problem Viewer");
                newFrame.getContentPane().add(newView);
                newFrame.pack();
                newFrame.setVisible(true);
            }
        } else {
            AbstractEAIndividual best = (AbstractEAIndividual)pop.getBestIndividual();
            if (this.indiesToPaint.size() == 0 || best.isDominant(this.indiesToPaint.getBestIndividual())) {
                if (this.indiesToPaint.size() == 1) {
                    this.indiesToPaint.set(0, best);
                } else {
                    this.indiesToPaint.add(best);
                }
                this.paint(this.getGraphics());
            }
        }
    }
}

