/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.GAPIndividualProgramData;
import eva2.optimization.individuals.GPIndividualProgramData;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.individuals.InterfaceDataTypeProgram;
import eva2.optimization.individuals.codings.gp.AbstractGPNode;
import eva2.optimization.individuals.codings.gp.GPArea;
import eva2.optimization.individuals.codings.gp.GPNodeAbs;
import eva2.optimization.individuals.codings.gp.GPNodeAdd;
import eva2.optimization.individuals.codings.gp.GPNodeCos;
import eva2.optimization.individuals.codings.gp.GPNodeDiv;
import eva2.optimization.individuals.codings.gp.GPNodeExp;
import eva2.optimization.individuals.codings.gp.GPNodeInput;
import eva2.optimization.individuals.codings.gp.GPNodeMult;
import eva2.optimization.individuals.codings.gp.GPNodeOne;
import eva2.optimization.individuals.codings.gp.GPNodePi;
import eva2.optimization.individuals.codings.gp.GPNodePow2;
import eva2.optimization.individuals.codings.gp.GPNodePow3;
import eva2.optimization.individuals.codings.gp.GPNodeSin;
import eva2.optimization.individuals.codings.gp.GPNodeSqrt;
import eva2.optimization.individuals.codings.gp.GPNodeSub;
import eva2.optimization.individuals.codings.gp.InterfaceProgram;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.problems.InterfaceProgramProblem;
import eva2.problems.regression.InterfaceRegressionFunction;
import eva2.problems.regression.RFKoza_GPI_7_3;
import eva2.tools.EVAERROR;
import eva2.tools.ToolBox;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The task is to infer the equation of a system that can only be observed at a number of checkpoints.")
public class PSymbolicRegression
extends AbstractOptimizationProblem
implements InterfaceProgramProblem,
InterfaceAdditionalPopulationInformer,
Serializable {
    private double[] x = new double[1];
    private int numberOfConstants = 3;
    private double lowerBound = -1.0;
    private double upperBound = 1.0;
    private int numberOfCheckPoints = 20;
    private transient InterfaceRegressionFunction targetFunction = new RFKoza_GPI_7_3();
    private double[] constants = new double[this.numberOfConstants];
    private boolean useInnerConst = false;
    private boolean useLocalHillClimbing = false;
    private GPArea gpArea = new GPArea();
    protected AbstractEAIndividual overallBestIndividuum = null;
    protected double noise = 0.0;
    private transient Plot plot;
    private boolean show = false;

    public PSymbolicRegression() {
        this.template = new GPIndividualProgramData();
        this.initializeProblem();
        this.compileArea();
    }

    public PSymbolicRegression(PSymbolicRegression b) {
        if (b.template != null) {
            this.template = (AbstractEAIndividual)b.template.clone();
        }
        if (b.overallBestIndividuum != null) {
            this.overallBestIndividuum = (AbstractEAIndividual)b.overallBestIndividuum.clone();
        }
        if (b.gpArea != null) {
            this.gpArea = (GPArea)b.gpArea.clone();
        }
        if (b.targetFunction != null) {
            this.targetFunction = (InterfaceRegressionFunction)b.targetFunction.clone();
        }
        if (b.x != null) {
            this.x = new double[b.x.length];
            System.arraycopy(b.x, 0, this.x, 0, this.x.length);
        }
        if (b.constants != null) {
            this.constants = new double[b.constants.length];
            System.arraycopy(b.constants, 0, this.constants, 0, this.constants.length);
        }
        this.noise = b.noise;
        this.useInnerConst = b.useInnerConst;
        this.useLocalHillClimbing = b.useLocalHillClimbing;
        this.numberOfConstants = b.numberOfConstants;
        this.lowerBound = b.lowerBound;
        this.upperBound = b.upperBound;
        this.numberOfCheckPoints = b.numberOfCheckPoints;
        this.lowerBound = b.lowerBound;
    }

    @Override
    public Object clone() {
        return new PSymbolicRegression(this);
    }

    @Override
    public void initializeProblem() {
        if (this.targetFunction == null) {
            this.targetFunction = new RFKoza_GPI_7_3();
        }
        this.overallBestIndividuum = null;
        this.constants = new double[this.numberOfConstants];
        for (int i = 0; i < this.constants.length; ++i) {
            this.constants[i] = RNG.randomDouble(-10.0, 10.0);
        }
    }

    private void compileArea() {
        GPArea oldArea = this.gpArea;
        this.gpArea = new GPArea();
        if (this.gpArea.isEmpty()) {
            int i;
            this.gpArea.add2CompleteList(new GPNodeOne());
            this.gpArea.add2CompleteList(new GPNodePi(), false);
            this.gpArea.add2CompleteList(new GPNodeAdd());
            this.gpArea.add2CompleteList(new GPNodeSub());
            this.gpArea.add2CompleteList(new GPNodeDiv());
            this.gpArea.add2CompleteList(new GPNodeMult());
            this.gpArea.add2CompleteList(new GPNodeAbs(), false);
            this.gpArea.add2CompleteList(new GPNodeSin(), false);
            this.gpArea.add2CompleteList(new GPNodeCos(), false);
            this.gpArea.add2CompleteList(new GPNodeExp(), false);
            this.gpArea.add2CompleteList(new GPNodeSqrt(), false);
            this.gpArea.add2CompleteList(new GPNodePow2(), false);
            this.gpArea.add2CompleteList(new GPNodePow3(), false);
            for (i = 0; i < this.x.length; ++i) {
                this.gpArea.add2CompleteList(new GPNodeInput("X" + i));
            }
            for (i = 0; i < this.constants.length; ++i) {
                this.gpArea.add2CompleteList(new GPNodeInput("C" + i), false);
            }
        }
        if (oldArea != null && oldArea.getBlackList() != null && oldArea.getBlackList().size() == this.gpArea.getBlackList().size()) {
            this.gpArea.SetBlackList(oldArea.getBlackList());
        }
        this.gpArea.compileReducedList();
    }

    @Override
    public void initializePopulation(Population population) {
        PSymbolicRegression.initializePopulation(population, this, this.useInnerConst, this.numberOfConstants);
    }

    public static void initializePopulation(Population pop, InterfaceProgramProblem prob, boolean useInnerConsts, int numConsts) {
        AbstractEAIndividual template = ((AbstractOptimizationProblem)((Object)prob)).getIndividualTemplate();
        Object[] tmpArea = new GPArea[]{prob.getArea()};
        ((InterfaceDataTypeProgram)((Object)template)).setProgramDataLength(1);
        ((InterfaceDataTypeProgram)((Object)template)).SetFunctionArea(tmpArea);
        if (template instanceof GAPIndividualProgramData && useInnerConsts) {
            ((GAPIndividualProgramData)template).setDoubleDataLength(numConsts);
        }
        AbstractOptimizationProblem.defaultInitializePopulation(pop, template, prob);
    }

    private void initEnvironmentPanel() {
        if (this.plot == null) {
            this.plot = new Plot("Symbolic Regression", "x", "y", true);
        }
    }

    @Override
    public void evaluate(Population population) {
        this.evaluatePopulationStart(population);
        for (int i = 0; i < population.size(); ++i) {
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)population.get(i);
            tmpIndy.resetConstraintViolation();
            if (this.useLocalHillClimbing && tmpIndy instanceof GAPIndividualProgramData) {
                AbstractEAIndividual tmpBestConst = (AbstractEAIndividual)((Object)((GAPIndividualProgramData)tmpIndy).getNumbers());
                this.evaluate(tmpIndy);
                tmpBestConst.SetFitness(0, tmpIndy.getFitness(0));
                population.incrFunctionCalls();
                for (int j = 0; j < 10; ++j) {
                    AbstractEAIndividual tmpConst = (AbstractEAIndividual)tmpBestConst.clone();
                    tmpConst.mutate();
                    ((GAPIndividualProgramData)tmpIndy).setNumbers((InterfaceDataTypeDouble)((Object)tmpConst));
                    this.evaluate(tmpIndy);
                    tmpConst.SetFitness(0, tmpIndy.getFitness(0));
                    population.incrFunctionCalls();
                    if (!(tmpBestConst.getFitness(0) > tmpConst.getFitness(0))) continue;
                    tmpBestConst = (AbstractEAIndividual)tmpConst.clone();
                }
                ((GAPIndividualProgramData)tmpIndy).setNumbers((InterfaceDataTypeDouble)((Object)tmpBestConst));
                tmpIndy.SetFitness(0, tmpBestConst.getFitness(0));
                continue;
            }
            if (this.useLocalHillClimbing) {
                EVAERROR.errorMsgOnce("Error: local hill climbing only works on GAPIndividualProgramData individuals!");
            }
            this.evaluate(tmpIndy);
            population.incrFunctionCalls();
        }
        this.evaluatePopulationEnd(population);
    }

    @Override
    public void evaluate(AbstractEAIndividual individual) {
        double tmpValue;
        double fitness = 0.0;
        InterfaceDataTypeProgram tmpIndy = (InterfaceDataTypeProgram)((Object)individual);
        InterfaceProgram program = tmpIndy.getProgramData()[0];
        if (tmpIndy instanceof GAPIndividualProgramData && this.useInnerConst) {
            this.constants = ((GAPIndividualProgramData)tmpIndy).getDoubleData();
        }
        fitness = 0.0;
        for (int j = 0; j < this.numberOfCheckPoints; ++j) {
            this.setCheckPoint(this.x, j);
            tmpValue = (Double)program.evaluate(this);
            fitness += Math.pow(this.targetFunction.evaluateFunction(this.x) - (Double)program.evaluate(this), 2.0);
        }
        fitness /= (double)this.numberOfCheckPoints;
        individual.SetFitness(0, fitness += RNG.gaussianDouble(this.noise));
        if (this.plot != null && this.plot.getFunctionArea().getContainerSize() == 0) {
            this.overallBestIndividuum = null;
        }
        if (this.overallBestIndividuum == null || this.overallBestIndividuum.getFitness(0) > individual.getFitness(0)) {
            this.overallBestIndividuum = (AbstractEAIndividual)individual.clone();
            if (this.show) {
                if (this.plot == null) {
                    this.initEnvironmentPanel();
                }
                this.plot.clearAll();
                program = ((InterfaceDataTypeProgram)((Object)this.overallBestIndividuum)).getProgramData()[0];
                for (int i = 0; i < this.numberOfCheckPoints; ++i) {
                    this.setCheckPoint(this.x, i);
                    tmpValue = (Double)program.evaluate(this);
                    this.plot.setConnectedPoint(this.x[0], tmpValue, 0);
                    tmpValue = this.targetFunction.evaluateFunction(this.x);
                    this.plot.setConnectedPoint(this.x[0], tmpValue, 1);
                    this.plot.setInfoString(1, program.getStringRepresentation(), 1.0f);
                }
            }
        }
    }

    private void setCheckPoint(double[] x, int j) {
        for (int i = 0; i < x.length; ++i) {
            x[i] = this.lowerBound + (double)j * (this.upperBound - this.lowerBound) / (double)(this.numberOfCheckPoints - 1);
        }
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        String result = "Symbolic Regression Problem";
        return result;
    }

    @Override
    public Object getSensorValue(String sensor) {
        return PSymbolicRegression.getSensorValue(sensor, this.x, this.constants);
    }

    public static Object getSensorValue(String sensor, double[] vars, double[] consts) {
        if (sensor.charAt(0) == 'X') {
            try {
                if (sensor.length() == 1) {
                    return vars;
                }
                int index = Integer.parseInt(sensor.substring(1));
                return vars[index];
            }
            catch (Exception e) {
                System.err.println("Warning, unable to access " + sensor);
                return vars;
            }
        }
        if (sensor.charAt(0) == 'C') {
            int index = Integer.parseInt(sensor.substring(1));
            return consts[index];
        }
        if (sensor.charAt(0) == 'N') {
            return (double)vars.length;
        }
        return 0.0;
    }

    @Override
    public void setActuatorValue(String actuator, Object parameter) {
    }

    @Override
    public String getName() {
        return "Symbolic Regression problem";
    }

    public void setNoise(double noise) {
        if (noise < 0.0) {
            noise = 0.0;
        }
        this.noise = noise;
    }

    public double getNoise() {
        return this.noise;
    }

    public String noiseTipText() {
        return "Noise level on the fitness value.";
    }

    public void setUseInnerConst(boolean b) {
        this.useInnerConst = b;
    }

    public boolean getUseInnerConst() {
        return this.useInnerConst;
    }

    public String useInnerConstTipText() {
        return "Toggle the use of inner constants.";
    }

    public void setUseLocalHillClimbing(boolean b) {
        this.useLocalHillClimbing = b;
    }

    public boolean getUseLocalHillClimbing() {
        return this.useLocalHillClimbing;
    }

    public String useLocalHillClimbingTipText() {
        return "Toggle the use of local hill climbing for inner constants.";
    }

    public void setNumberOfConstants(int b) {
        this.numberOfConstants = b;
        this.initializeProblem();
        this.gpArea.clear();
        this.compileArea();
    }

    public int getNumberOfConstants() {
        return this.numberOfConstants;
    }

    public String numberOfConstantsTipText() {
        return "Gives the number of ephremal constants.";
    }

    public void setNumberOfCheckPoints(int b) {
        if (b < 0) {
            b = 1;
        }
        this.numberOfCheckPoints = b;
    }

    public int getNumberOfCheckPoints() {
        return this.numberOfCheckPoints;
    }

    public String numberOfCheckPointsTipText() {
        return "Choose the number of points where the GP have to compare to the target function.";
    }

    public void setArea(GPArea i) {
        this.gpArea = i;
        Object[] tmpArea = new GPArea[]{this.gpArea};
        ((InterfaceDataTypeProgram)((Object)this.template)).setProgramDataLength(1);
        ((InterfaceDataTypeProgram)((Object)this.template)).SetFunctionArea(tmpArea);
    }

    @Override
    public GPArea getArea() {
        if (this.gpArea == null) {
            this.initializeProblem();
        }
        return this.gpArea;
    }

    public String areaTipText() {
        return "Select function set from the available area.";
    }

    public void setShowResult(boolean b) {
        this.show = b;
        if (this.show) {
            this.initEnvironmentPanel();
        } else if (this.plot != null) {
            this.plot.dispose();
            this.plot = null;
        }
    }

    public boolean getShowResult() {
        return this.show;
    }

    public String showResultTipText() {
        return "Toggles the result visualisation on/or off.";
    }

    public void setTargetFunction(InterfaceRegressionFunction b) {
        this.targetFunction = b;
    }

    public InterfaceRegressionFunction getTargetFunction() {
        if (this.targetFunction == null) {
            this.initializeProblem();
        }
        return this.targetFunction;
    }

    public String targetFunctionTipText() {
        return "Choose from the available target functions.";
    }

    public void setGPIndividual(InterfaceDataTypeProgram indy) {
        this.template = (AbstractEAIndividual)((Object)indy);
    }

    public InterfaceDataTypeProgram getGPIndividual() {
        return (InterfaceDataTypeProgram)((Object)this.template);
    }

    public String GPIndividualTipText() {
        return "Modify the properties of the template GP individual such as maximum tree depth etc.";
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double mLowerBound) {
        this.lowerBound = mLowerBound;
    }

    public String lowerBoundTipText() {
        return "The lower bound of the 1D double interval where the target function is sampled.";
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double mUpperBound) {
        this.upperBound = mUpperBound;
    }

    public String upperBoundTipText() {
        return "The upper bound of the 1D double interval where the target function is sampled.";
    }

    public String[] customPropertyOrder() {
        return new String[]{"lowerBound", "upperBound"};
    }

    @Override
    public String[] getAdditionalDataHeader() {
        String[] superHd = super.getAdditionalDataHeader();
        return ToolBox.appendArrays(new String[]{"bestIndySize", "avgIndySize", "avgMaxIndyDepth"}, new String[][]{superHd});
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        Object[] superDat = super.getAdditionalDataValue(pop);
        return ToolBox.appendArrays(new Object[]{PSymbolicRegression.getBestIndySize(pop), PSymbolicRegression.getAvgIndySize(pop), PSymbolicRegression.getAvgIndyDepth(pop)}, new Object[][]{superDat});
    }

    public static double getAvgIndyDepth(PopulationInterface pop) {
        Population p = (Population)pop;
        double sum = 0.0;
        for (int i = 0; i < p.size(); ++i) {
            sum += (double)PSymbolicRegression.getIndyDepth(p.getEAIndividual(i));
        }
        return sum / (double)p.size();
    }

    public static double getAvgIndySize(PopulationInterface pop) {
        Population p = (Population)pop;
        double sum = 0.0;
        for (int i = 0; i < p.size(); ++i) {
            sum += (double)PSymbolicRegression.getIndySize(p.getEAIndividual(i));
        }
        return sum / (double)p.size();
    }

    public static int getBestIndySize(PopulationInterface pop) {
        Population p = (Population)pop;
        AbstractEAIndividual indy = p.getBestEAIndividual();
        return PSymbolicRegression.getIndySize(indy);
    }

    public static int getIndySize(AbstractEAIndividual indy) {
        if (indy instanceof InterfaceDataTypeProgram) {
            InterfaceProgram prog = ((InterfaceDataTypeProgram)((Object)indy)).getProgramDataWithoutUpdate()[0];
            if (prog instanceof AbstractGPNode) {
                AbstractGPNode gpNode = (AbstractGPNode)prog;
                return gpNode.getNumberOfNodes();
            }
            return 0;
        }
        return 0;
    }

    public static int getIndyDepth(AbstractEAIndividual indy) {
        if (indy instanceof InterfaceDataTypeProgram) {
            InterfaceProgram prog = ((InterfaceDataTypeProgram)((Object)indy)).getProgramDataWithoutUpdate()[0];
            if (prog instanceof AbstractGPNode) {
                AbstractGPNode gpNode = (AbstractGPNode)prog;
                int d = gpNode.getMaxDepth();
                return d;
            }
            return 0;
        }
        return 0;
    }

    public static double[] evalNodeString(String nodeStr) {
        AbstractGPNode node = AbstractGPNode.parseFromString(nodeStr);
        PSymbolicRegression regrProb = new PSymbolicRegression();
        GPIndividualProgramData indy = new GPIndividualProgramData();
        indy.setPGenotype(node, 0);
        regrProb.evaluate(indy);
        System.out.println("Evaluated individual: " + indy);
        return indy.getFitness();
    }
}

