/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.gui.BeanInspector;
import eva2.gui.editor.GenericObjectEditor;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.GAIndividualBinaryData;
import eva2.optimization.individuals.InterfaceDataTypeBinary;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.simple.InterfaceSimpleProblem;
import eva2.problems.simple.SimpleF1;
import eva2.problems.simple.SimpleProblemBinary;
import eva2.problems.simple.SimpleProblemDouble;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.util.BitSet;

@Description(value="Wrapping simple problem implementations.")
public class SimpleProblemWrapper
extends AbstractOptimizationProblem {
    InterfaceSimpleProblem<?> simProb = new SimpleF1();
    protected double defaultRange = 10.0;
    protected double noise = 0.0;
    private int repaintMinWait = 20;
    private int repaintCnt = 0;
    transient Plot plot = null;
    transient AbstractEAIndividual bestIndy = null;
    String plotFunc = "plotBest";
    transient Class[] plotFuncSig = new Class[]{Plot.class, AbstractEAIndividual.class};
    private transient boolean resetTemplate = true;

    public SimpleProblemWrapper() {
        this.plot = null;
        this.initTemplate();
    }

    public SimpleProblemWrapper(SimpleProblemWrapper other) {
        other.defaultRange = this.defaultRange;
        other.noise = this.noise;
        this.setSimpleProblem(other.simProb);
    }

    @Override
    public Object clone() {
        return new SimpleProblemWrapper(this);
    }

    @Override
    public void evaluate(AbstractEAIndividual individual) {
        if (this.simProb instanceof SimpleProblemDouble) {
            double[] x = new double[((InterfaceDataTypeDouble)((Object)individual)).getDoubleData().length];
            System.arraycopy(((InterfaceDataTypeDouble)((Object)individual)).getDoubleData(), 0, x, 0, x.length);
            double[] fitness = ((SimpleProblemDouble)this.simProb).evaluate(x);
            if (this.noise != 0.0) {
                RNG.addNoise(fitness, this.noise);
            }
            individual.setFitness(fitness);
        } else if (this.simProb instanceof SimpleProblemBinary) {
            BitSet tmpBitSet = ((InterfaceDataTypeBinary)((Object)individual)).getBinaryData();
            double[] result = ((SimpleProblemBinary)this.simProb).evaluate(tmpBitSet);
            individual.setFitness(result);
        } else {
            System.err.println("Error in SimpleProblemWrapper: " + this.simProb.getClass().getName() + " is unknown type!");
        }
    }

    @Override
    public void evaluatePopulationStart(Population population) {
        if (this.plot != null && !this.plot.isValid()) {
            this.openPlot();
        }
    }

    @Override
    public void evaluatePopulationEnd(Population population) {
        super.evaluatePopulationEnd(population);
        this.repaintCnt += population.size();
        if (this.plot != null && this.repaintCnt >= this.repaintMinWait) {
            if (this.bestIndy == null || population.getBestEAIndividual().isDominant(this.bestIndy.getFitness())) {
                this.bestIndy = population.getBestEAIndividual();
                Object[] args = new Object[]{this.plot, this.bestIndy};
                BeanInspector.callIfAvailable(this.simProb, this.plotFunc, args);
            }
            this.repaintCnt = 0;
        }
    }

    @Override
    public void initializePopulation(Population population) {
        this.initTemplate();
        AbstractOptimizationProblem.defaultInitializePopulation(population, this.template, this);
    }

    @Override
    public void initializeProblem() {
        this.bestIndy = null;
        this.initTemplate();
        this.setSimpleProblem(this.getSimpleProblem());
        BeanInspector.callIfAvailable(this.simProb, "initializeProblem", null);
    }

    protected void initTemplate() {
        if (this.resetTemplate) {
            if (this.simProb instanceof SimpleProblemDouble) {
                this.template = new ESIndividualDoubleData();
            } else if (this.simProb instanceof SimpleProblemBinary) {
                this.template = new GAIndividualBinaryData();
            }
        }
        if (this.template instanceof InterfaceDataTypeDouble) {
            ((InterfaceDataTypeDouble)((Object)this.template)).setDoubleDataLength(this.simProb.getProblemDimension());
            ((InterfaceDataTypeDouble)((Object)this.template)).setDoubleRange(this.makeRange());
        } else if (this.template instanceof InterfaceDataTypeBinary) {
            ((InterfaceDataTypeBinary)((Object)this.template)).setBinaryDataLength(this.simProb.getProblemDimension());
        } else {
            System.err.println("Individual type not valid!");
        }
    }

    protected double[][] makeRange() {
        double[][] range = new double[this.simProb.getProblemDimension()][2];
        for (int i = 0; i < range.length; ++i) {
            range[i][0] = this.getRangeLowerBound(i);
            range[i][1] = this.getRangeUpperBound(i);
        }
        return range;
    }

    protected double getRangeLowerBound(int dim) {
        return -this.defaultRange;
    }

    protected double getRangeUpperBound(int dim) {
        return this.defaultRange;
    }

    public InterfaceSimpleProblem<?> getSimpleProblem() {
        return this.simProb;
    }

    private void openPlot() {
        this.plot = new Plot("SimpleProblemWrapper", "x", "y", true);
    }

    @Parameter(description="Set the simple problem class which is to be optimized")
    public void setSimpleProblem(InterfaceSimpleProblem<?> simProb) {
        this.simProb = simProb;
        this.initTemplate();
        GenericObjectEditor.setShowProperty(this.getClass(), "noise", simProb instanceof SimpleProblemDouble);
        GenericObjectEditor.setShowProperty(this.getClass(), "defaultRange", simProb instanceof SimpleProblemDouble);
        if (BeanInspector.hasMethod(simProb, this.plotFunc, this.plotFuncSig) != null) {
            if (this.plot == null) {
                this.openPlot();
            } else if (!this.plot.isValid()) {
                this.plot.dispose();
                this.openPlot();
            } else {
                this.plot.clearAll();
            }
        } else if (this.plot != null) {
            this.plot.dispose();
            this.plot = null;
        }
    }

    @Parameter(description="Gaussian noise level on the fitness value.")
    public void setNoise(double noise) {
        if (noise < 0.0) {
            noise = 0.0;
        }
        this.noise = noise;
    }

    public double getNoise() {
        return this.noise;
    }

    public double getDefaultRange() {
        return this.defaultRange;
    }

    @Parameter(name="range", description="Absolute limit for the symmetric range in any dimension")
    public void setDefaultRange(double defaultRange) {
        this.defaultRange = defaultRange;
        this.initTemplate();
    }

    public void hideHideable() {
        this.setSimpleProblem(this.getSimpleProblem());
    }

    @Parameter(name="individual", description="Set the individual properties for the optimization")
    public void setIndividualTemplate(AbstractEAIndividual indy) {
        this.resetTemplate = false;
        this.template = indy;
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("A wrapped simple problem based on ");
        sb.append(this.simProb.getClass().getName());
        sb.append(", Dimension   : ");
        sb.append(this.simProb.getProblemDimension());
        return sb.toString();
    }

    @Override
    public String getName() {
        return "SimpleProblemWrapper";
    }

    public String[] getGOEPropertyUpdateLinks() {
        return new String[]{"simpleProblem"};
    }
}

