/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.gui.PropertyFilePath;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.constraint.InterfaceConstraint;
import eva2.optimization.operator.moso.InterfaceMOSOConverter;
import eva2.optimization.operator.paretofrontmetrics.InterfaceParetoFrontMetric;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.problems.AbstractOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="T1 is to be minimized.")
public class TF1Problem
extends AbstractMultiObjectiveOptimizationProblem
implements Serializable {
    protected int outputDimension = 2;
    protected double noise = 0.0;
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;
    protected boolean applyConstraints = false;

    public TF1Problem() {
        super(1.0);
    }

    public TF1Problem(double borderHigh) {
        super(borderHigh);
    }

    public TF1Problem(TF1Problem b) {
        int i;
        if (b.template != null) {
            this.template = (AbstractEAIndividual)b.template.clone();
        }
        if (b.mosoConverter != null) {
            this.mosoConverter = (InterfaceMOSOConverter)b.mosoConverter.clone();
        }
        if (b.metric != null) {
            this.metric = (InterfaceParetoFrontMetric)b.metric.clone();
        }
        if (b.paretoFront != null) {
            this.paretoFront = (Population)b.paretoFront.clone();
        }
        if (b.border != null) {
            this.border = new double[b.border.length][2];
            for (i = 0; i < this.border.length; ++i) {
                this.border[i][0] = b.border[i][0];
                this.border[i][1] = b.border[i][1];
            }
        }
        if (b.areaConst4Parallelization != null) {
            this.areaConst4Parallelization = new ArrayList();
            for (i = 0; i < b.areaConst4Parallelization.size(); ++i) {
                this.areaConst4Parallelization.add(((InterfaceConstraint)b.areaConst4Parallelization.get(i)).clone());
            }
        }
        this.applyConstraints = b.applyConstraints;
        this.problemDimension = b.problemDimension;
        this.outputDimension = b.outputDimension;
        this.noise = b.noise;
        this.xOffset = b.xOffset;
        this.yOffset = b.yOffset;
    }

    @Override
    public Object clone() {
        return new TF1Problem(this);
    }

    @Override
    public void initializePopulation(Population population) {
        this.paretoFront = new Population();
        double[][] newRange = this.makeRange();
        ((InterfaceDataTypeDouble)((Object)this.template)).setDoubleDataLength(this.problemDimension);
        ((InterfaceDataTypeDouble)((Object)this.template)).setDoubleRange(newRange);
        AbstractOptimizationProblem.defaultInitializePopulation(population, this.template, this);
    }

    protected double[][] makeRange() {
        return this.makeRange(0.0, 1.0);
    }

    protected double[][] makeRange(double lower, double upper) {
        double[][] newRange = new double[this.problemDimension][2];
        for (int i = 0; i < this.problemDimension; ++i) {
            newRange[i][0] = lower;
            newRange[i][1] = upper;
        }
        return newRange;
    }

    @Override
    public void evaluate(AbstractEAIndividual individual) {
        double[] x = new double[((InterfaceDataTypeDouble)((Object)individual)).getDoubleData().length];
        System.arraycopy(((InterfaceDataTypeDouble)((Object)individual)).getDoubleData(), 0, x, 0, x.length);
        int i = 0;
        while (i < x.length) {
            int n = i++;
            x[n] = x[n] - this.xOffset;
        }
        double[] fitness = this.doEvaluation(x);
        for (i = 0; i < fitness.length; ++i) {
            int n = i;
            fitness[n] = fitness[n] + RNG.gaussianDouble(this.noise);
            int n2 = i;
            fitness[n2] = fitness[n2] + this.yOffset;
            individual.SetFitness(i, fitness[i]);
        }
        if (this.applyConstraints) {
            if (fitness[0] > 0.5) {
                individual.addConstraintViolation(fitness[0] - 0.5);
            }
            if (x[1] > 0.1) {
                individual.addConstraintViolation(x[1] - 0.1);
            }
            if (x[2] > 0.1) {
                individual.addConstraintViolation(x[2] - 0.1);
            }
            if (x[3] > 0.1) {
                individual.addConstraintViolation(x[3] - 0.1);
            }
        }
        individual.checkAreaConst4Parallelization(this.areaConst4Parallelization);
    }

    public double[] doEvaluation(double[] x) {
        double[] result = new double[2];
        double g = 0.0;
        result[0] = x[0];
        g = this.g(x);
        result[1] = g * this.h(result[0], g);
        return result;
    }

    protected double g(double[] x) {
        double result = 0.0;
        for (int i = 1; i < x.length; ++i) {
            result += x[i];
        }
        result = result * 9.0 / (double)(x.length - 1);
        return result += 1.0;
    }

    protected double h(double x, double y) {
        double result = 0.0;
        result = 1.0 - Math.sqrt(Math.abs(x / y));
        return result;
    }

    @Override
    public void drawAdditionalData(Plot plot, Population pop, int index) {
        AbstractMultiObjectiveOptimizationProblem.drawWithConstraints(plot, pop, this.border, index);
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        String result = "";
        result = result + "T1 Problem:\n";
        result = result + "Here the individual codes a vector of real number x and T1(x)= x is to be minimized.\n";
        result = result + "Parameters:\n";
        result = result + "Dimension   : " + this.problemDimension + "\n";
        result = result + "Noise level : " + this.noise + "\n";
        result = result + "Solution representation:\n";
        return result;
    }

    public static void main(String[] args) {
        int points = 500;
        String base = System.getProperty("user.dir");
        String FS = System.getProperty("file.separator");
        PropertyFilePath fileOutPath = PropertyFilePath.getFilePathFromResource("MOPReference" + FS + "T1_" + points + ".txt");
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(fileOutPath.getCompleteFilePath()));
        }
        catch (IOException ed) {
            System.out.println("Could not open " + fileOutPath.getCompleteFilePath());
            return;
        }
        TF1Problem problem = new TF1Problem();
        System.out.println("This method generates a reference set for the T1 problem with " + points + " sample points.");
        double ub = 1.0;
        double lb = 0.0;
        String tmpStr = "x1 \t x2";
        for (int i = 0; i < points + 1; ++i) {
            double x1 = (ub - lb) / (double)points * (double)i;
            double x2 = problem.h(x1, 1.0);
            tmpStr = tmpStr + "\n" + x1 + "\t" + x2;
        }
        try {
            writer.write(tmpStr);
            writer.close();
        }
        catch (IOException e) {
            System.out.println("DAMM IOException " + e);
        }
    }

    @Override
    public String getName() {
        return "T1 Problem";
    }

    public void setNoise(double noise) {
        if (noise < 0.0) {
            noise = 0.0;
        }
        this.noise = noise;
    }

    public double getNoise() {
        return this.noise;
    }

    public String noiseTipText() {
        return "Noise level on the fitness value.";
    }

    public void setXOffSet(double XOffSet) {
        this.xOffset = XOffSet;
    }

    public double getXOffSet() {
        return this.xOffset;
    }

    public String xOffSetTipText() {
        return "Choose an offset for the decision variable.";
    }

    public void setYOffSet(double YOffSet) {
        this.yOffset = YOffSet;
    }

    public double getYOffSet() {
        return this.yOffset;
    }

    public String yOffSetTipText() {
        return "Choose an offset for the objective value.";
    }

    @Override
    public void setProblemDimension(int d) {
        this.problemDimension = d;
    }

    public void setEAIndividual(InterfaceDataTypeDouble indy) {
        this.template = (AbstractEAIndividual)((Object)indy);
    }

    public InterfaceDataTypeDouble getEAIndividual() {
        return (InterfaceDataTypeDouble)((Object)this.template);
    }

    @Override
    public void setMOSOConverter(InterfaceMOSOConverter b) {
        this.mosoConverter = b;
        this.mosoConverter.setOutputDimension(this.outputDimension);
    }

    @Override
    public InterfaceMOSOConverter getMOSOConverter() {
        return this.mosoConverter;
    }

    @Override
    public String mOSOConverterTipText() {
        return "Choose a Multiobjective to Singleobjective converter.";
    }

    public void setParetoFront(Population pop) {
        this.paretoFront = pop;
    }

    public Population getParetoFront() {
        return this.paretoFront;
    }

    public String paretoFrontTipText() {
        return "Choose the properties of the local log of the pareto-front.";
    }
}

