/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.OptimizerRunnable;
import eva2.gui.BeanInspector;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.statistics.InterfaceStatisticsParameters;
import eva2.problems.MatlabProblem;
import java.io.PrintWriter;
import java.io.StringWriter;

final class WaitForEvARunnable
implements Runnable {
    OptimizerRunnable runnable;
    MatlabProblem mp;

    public WaitForEvARunnable(OptimizerRunnable runnable, MatlabProblem mp) {
        this.runnable = runnable;
        this.mp = mp;
        mp.log("Created WaitForEvARunnable " + this + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.runnable != null) {
            this.mp.log("\nStarting optimize runnable!\n");
            OptimizerRunnable optimizerRunnable = this.runnable;
            synchronized (optimizerRunnable) {
                try {
                    new Thread(this.runnable).start();
                    this.mp.log("Started optimize thread\n");
                    this.runnable.wait();
                    this.mp.log("runnable continues...\n");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.mp.log("WaitForEvARunnable was interrupted with " + e.getMessage());
                }
            }
            try {
                this.mp.log("runnable.getDoubleSolution: " + BeanInspector.toString(this.runnable.getDoubleSolution()) + "\n");
                this.mp.log("runnable.getIntegerSolution: " + BeanInspector.toString(this.runnable.getIntegerSolution()) + "\n");
                this.mp.log("getAllSols best: " + AbstractEAIndividual.getDefaultDataString(this.runnable.getOptimizationParameters().getOptimizer().getAllSolutions().getSolutions().getBestEAIndividual()) + "\n");
                this.mp.log("\n");
                this.mp.exportResultToMatlab(this.runnable);
                this.mp.exportResultPopulationToMatlab(this.runnable.getResultPopulation());
                this.mp.log("reported results.\n");
                this.mp.notifyFinished();
                this.mp.log("notified finish.\n");
                if (this.mp.verbosityLevel != InterfaceStatisticsParameters.OutputVerbosity.NONE) {
                    System.out.println("Optimization finished: " + this.mp.getInfoString());
                }
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                this.mp.log("error in callback: " + e.getMessage() + " " + sw.toString() + "\n");
            }
        } else {
            System.err.println("Invalid optimization call.");
            this.mp.log("invalid call, no optimization started.\n");
            this.mp.exportResultToMatlab(null);
            this.mp.exportResultPopulationToMatlab(null);
            this.mp.log("notifying finish...\n");
            this.mp.notifyFinished();
            this.mp.log("notified finish.\n");
        }
    }
}

