/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools;

import eva2.EvAInfo;
import eva2.tools.ResourceLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class BasicResourceLoader
implements ResourceLoader {
    private static Logger logger = Logger.getLogger(BasicResourceLoader.class.getName());
    private static BasicResourceLoader resourceLoader;

    private BasicResourceLoader() {
    }

    public static synchronized BasicResourceLoader getInstance() {
        if (resourceLoader == null) {
            resourceLoader = new BasicResourceLoader();
        }
        return resourceLoader;
    }

    public static List<String> readLines(String resourceFile) {
        return BasicResourceLoader.readLines(resourceFile, false);
    }

    public static List<String> readLines(String resourceFile, boolean ignoreCommentedLines) {
        return BasicResourceLoader.readLines(resourceFile, new String[]{"#"}, 0, -1);
    }

    public static List<String> readLines(String resourceFile, String[] ignorePrefix, int lOffset, int lCnt) {
        if (resourceFile == null) {
            return null;
        }
        byte[] bytes = BasicResourceLoader.getInstance().getBytesFromResourceLocation(resourceFile, false);
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream sReader = new ByteArrayInputStream(bytes);
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(sReader));
        ArrayList<String> lineData = new ArrayList<String>(100);
        int lineCnt = 0;
        try {
            String line;
            while ((line = lnr.readLine()) != null) {
                if (BasicResourceLoader.strStartsWithPrefix(line = line.trim(), ignorePrefix) >= 0) continue;
                if (lineCnt >= lOffset) {
                    lineData.add(line);
                }
                ++lineCnt;
                if (lCnt <= 0 || lineData.size() != lCnt) continue;
                break;
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return lineData;
    }

    public static double[][] parseDoubleArray(ArrayList<String> rawData, String colSplit, int[] selectedCols) {
        double[][] dat = null;
        if (rawData != null) {
            try {
                for (int i = 0; i < rawData.size(); ++i) {
                    String[] entries = rawData.get(i).split(colSplit);
                    if (i == 0) {
                        dat = new double[rawData.size()][selectedCols == null ? entries.length : selectedCols.length];
                    }
                    BasicResourceLoader.trimAll(entries);
                    BasicResourceLoader.fillLine(dat, i, entries, selectedCols);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(e.getMessage());
            }
        }
        return dat;
    }

    private static void trimAll(String[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i] == null) continue;
            entries[i] = entries[i].trim();
        }
    }

    public static double[][] getLinesByCol(double[][] data, int col, double start, double end) {
        int cnt = 0;
        int startIndex = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i][col] >= start && data[i][col] <= end) {
                if (cnt == 0) {
                    startIndex = i;
                }
                ++cnt;
                continue;
            }
            if (cnt > 0) break;
        }
        double[][] selData = new double[cnt][data[0].length];
        System.arraycopy(data, startIndex, selData, 0, cnt);
        return selData;
    }

    public static double[][] loadDoubleData(String fname, String[] ignorePrefix, String colSplit, int lOffset, int lCnt, int[] selectedCols) {
        return BasicResourceLoader.parseDoubleArray((ArrayList)BasicResourceLoader.readLines(fname, ignorePrefix, lOffset, lCnt), colSplit, selectedCols);
    }

    public static void fillLine(double[][] dest, int lineCnt, String[] entries, int[] cols) {
        if (cols == null && dest[lineCnt].length < entries.length || cols != null && dest[lineCnt].length != cols.length) {
            System.err.println("error, array dimensions dont match! (BasicResourceLoader)");
        }
        if (cols == null) {
            for (int i = 0; i < dest[lineCnt].length; ++i) {
                try {
                    if (i >= entries.length || entries[i] == null || entries[i].length() == 0) {
                        dest[lineCnt][i] = Double.NaN;
                        continue;
                    }
                    dest[lineCnt][i] = Double.valueOf(entries[i]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid Double format in line " + lineCnt + ", data was " + entries[i]);
                    dest[lineCnt][i] = Double.NaN;
                }
            }
        } else {
            for (int i = 0; i < cols.length; ++i) {
                try {
                    if (cols[i] < 0 || cols[i] >= entries.length || entries[cols[i]] == null || entries[cols[i]].length() == 0) {
                        dest[lineCnt][i] = Double.NaN;
                        continue;
                    }
                    dest[lineCnt][i] = Double.valueOf(entries[cols[i]]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid Double format in line " + lineCnt + ", data was " + entries[cols[i]]);
                    dest[lineCnt][i] = Double.NaN;
                }
            }
        }
    }

    public static int strStartsWithPrefix(String str, String[] pref) {
        int i = 0;
        if (pref != null) {
            for (String prefix : pref) {
                if (str.startsWith(prefix)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public InputStream getStreamFromResourceLocation(String rawResrcLoc) {
        String resourceLocation = rawResrcLoc.replace('\\', '/');
        if (resourceLocation == null) {
            return null;
        }
        resourceLocation = resourceLocation.trim();
        InputStream in = null;
        if (resourceLocation.startsWith("..") || resourceLocation.startsWith("/") || resourceLocation.startsWith("\\") || resourceLocation.length() > 1 && resourceLocation.charAt(1) == ':') {
            in = this.getStreamFromFile(resourceLocation);
        }
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(resourceLocation);
        }
        if (in == null) {
            in = this.getClass().getClassLoader().getResourceAsStream(resourceLocation);
        }
        if (in == null) {
            // empty if block
        }
        if (in == null) {
            logger.log(Level.FINER, "Unable to open stream for " + resourceLocation);
        } else {
            logger.log(Level.FINER, "Stream opened for " + resourceLocation);
        }
        return in;
    }

    @Override
    public byte[] getBytesFromResourceLocation(String rawResrcLoc) {
        return this.getBytesFromResourceLocation(rawResrcLoc, false);
    }

    public byte[] getBytesFromResourceLocation(String rawResrcLoc, boolean exceptionOnNotFound) {
        InputStream in = this.getStreamFromResourceLocation(rawResrcLoc);
        byte[] arr = null;
        if (in != null) {
            arr = this.getBytesFromStream(in);
        }
        if (exceptionOnNotFound && arr == null) {
            throw new RuntimeException(EvAInfo.resourceNotFoundErrorMessage(rawResrcLoc));
        }
        return arr;
    }

    private byte[] getBytesFromArchive(String urlToZipArchive, String internalArchivePath) {
        URL url = null;
        int size = -1;
        byte[] b = null;
        try {
            url = new URL(urlToZipArchive);
            ZipFile zf = new ZipFile(url.getFile());
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (!ze.getName().equals(internalArchivePath)) continue;
                if (ze.isDirectory()) {
                    return null;
                }
                if (ze.getSize() > 65536L) {
                    System.out.println("Resource files should be smaller than 65536 bytes...");
                }
                size = (int)ze.getSize();
            }
            zf.close();
            FileInputStream fis = new FileInputStream(url.getFile());
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (!ze.getName().equals(internalArchivePath)) continue;
                b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0 && (chunk = zis.read(b, rb, size - rb)) != -1) {
                    rb += chunk;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
        return b;
    }

    private FileInputStream getStreamFromFile(String fileName) {
        if (fileName.startsWith("/cygdrive/")) {
            int length = "/cygdrive/".length();
            fileName = fileName.substring(length, length + 1) + ":" + fileName.substring(length + 1);
        }
        logger.log(Level.FINER, "Trying to get file from " + fileName);
        File file = new File(fileName);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            return fis;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    private byte[] getBytesFromFile(String fileName) {
        FileInputStream fis = this.getStreamFromFile(fileName);
        if (fis == null) {
            System.err.println("couldnt get file input stream!");
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(fis);
        int size = (int)new File(fileName).length();
        byte[] b = new byte[size];
        int rb = 0;
        int chunk = 0;
        try {
            while (size - rb > 0 && (chunk = bis.read(b, rb, size - rb)) != -1) {
                rb += chunk;
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
        return b;
    }

    private byte[] getBytesFromStream(InputStream stream) {
        if (stream == null) {
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(stream);
        try {
            int size = bis.available();
            byte[] b = new byte[size];
            int rb = 0;
            int chunk = 0;
            while (size - rb > 0 && (chunk = bis.read(b, rb, size - rb)) != -1) {
                rb += chunk;
            }
            return b;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    public static Properties readProperties(String resourceName) throws Exception {
        int slInd;
        Properties prop = new Properties();
        BasicResourceLoader loader = BasicResourceLoader.getInstance();
        byte[] bytes = loader.getBytesFromResourceLocation(resourceName, false);
        if (bytes != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            prop.load(bais);
            if (prop != null) {
                return prop;
            }
        }
        String planBResName = (slInd = resourceName.lastIndexOf(47)) != -1 ? resourceName.substring(slInd + 1) : resourceName;
        Properties userProps = new Properties();
        File propFile = new File(File.separatorChar + planBResName);
        if (propFile.exists()) {
            try {
                userProps.load(new FileInputStream(propFile));
            }
            catch (Exception ex) {
                System.err.println("Problem reading user properties: " + propFile);
            }
        } else {
            System.err.println("Warning in readProperties: neither " + resourceName + " nor " + planBResName + " could be read.");
        }
        return userProps;
    }
}

