/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools;

import eva2.tools.math.RNG;

public class KMEANSJAVA {
    protected double[][] c;
    protected int[] indices;

    public double[][] getC() {
        return this.c;
    }

    public int[] getIDX() {
        return this.indices;
    }

    private double dist(double[] x1, double[] x2) {
        double ret = 0.0;
        for (int i = 0; i < x1.length; ++i) {
            ret += (x1[i] - x2[i]) * (x1[i] - x2[i]);
        }
        return Math.sqrt(ret);
    }

    public KMEANSJAVA(double[][] samples, int K, int iterations) {
        int i;
        if (K > samples.length) {
            K = samples.length;
        }
        int counter = 0;
        this.c = new double[K][];
        for (i = 0; i < K; ++i) {
            this.c[i] = (double[])samples[i].clone();
        }
        this.indices = new int[samples.length];
        while (counter++ < iterations) {
            for (i = 0; i < this.indices.length; ++i) {
                int index_nc = 0;
                double mindist = 9.99999999E8;
                for (int j = 0; j < this.c.length; ++j) {
                    if (!(mindist > this.dist(samples[i], this.c[j]))) continue;
                    mindist = this.dist(samples[i], this.c[j]);
                    index_nc = j;
                }
                this.indices[i] = index_nc;
            }
            for (int indexofc = 0; indexofc < this.c.length; ++indexofc) {
                double[] newcenter = new double[samples[0].length];
                int treffer = 0;
                for (int indice : this.indices) {
                    if (indice != indexofc) continue;
                    ++treffer;
                    for (int d = 0; d < newcenter.length; ++d) {
                        int n = d;
                        newcenter[n] = newcenter[n] + this.c[indice][d];
                    }
                }
                int d = 0;
                while (d < newcenter.length) {
                    int n = d++;
                    newcenter[n] = newcenter[n] / (double)treffer;
                }
                this.c[indexofc] = newcenter;
            }
        }
    }

    public static void main(String[] args) {
        int k = 3;
        int samples = 10;
        int d = 2;
        double[][] test = new double[samples][d];
        for (int i = 0; i < samples; ++i) {
            for (int j = 0; j < d; ++j) {
                test[i][j] = RNG.randomDouble(0.0, 10.0);
            }
        }
        KMEANSJAVA app = new KMEANSJAVA(test, k, 5);
        double[][] c = app.getC();
        int[] idx = app.getIDX();
        System.out.println("c");
        for (int i = 0; i < c.length; ++i) {
            for (int j = 0; j < c[i].length; ++j) {
                System.out.print(c[i][j] + " ");
            }
            System.out.println("");
        }
        System.out.println("test");
        for (double[] aTest : test) {
            for (int j = 0; j < aTest.length; ++j) {
                System.out.print(aTest[j] + " ");
            }
            System.out.println("");
        }
    }
}

