/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools;

import eva2.tools.TXTFileFilter;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MultirunRefiner {
    private JFrame mainFrame;
    private JPanel myPanel;
    private JPanel myJButtonJPanel;
    private JButton refineJButton;
    private JButton exitJButton;
    private JTextArea inputText;
    private JTextArea outputText;
    private JScrollPane scrollPane1;
    private JScrollPane scrollPane2;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem loadMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem exitMenuItem;

    public MultirunRefiner() {
    }

    public MultirunRefiner(File f) {
        this.starter();
        if (!this.readFile(f)) {
            System.err.println("Error, couldnt open file " + f);
        }
    }

    public MultirunRefiner(String fileName) {
        this.starter();
        File f = new File(fileName);
        if (!this.readFile(f)) {
            System.err.println("Error, couldnt open file " + f);
        }
    }

    public MultirunRefiner(String text, int numRuns) {
        this.starter();
        this.inputText.setText(text);
    }

    public void starter() {
        this.mainFrame = new JFrame("MultirunRefiner\u2122");
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.loadMenuItem = new JMenuItem("Load");
        this.loadMenuItem.setEnabled(true);
        this.loadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MultirunRefiner.this.loadFile();
            }
        });
        this.saveMenuItem = new JMenuItem("Save");
        this.saveMenuItem.setEnabled(true);
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultirunRefiner.this.writeFile();
            }
        });
        this.exitMenuItem = new JMenuItem("Exit");
        this.exitMenuItem.setEnabled(true);
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        this.fileMenu.add(this.loadMenuItem);
        this.fileMenu.add(this.saveMenuItem);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.exitMenuItem);
        this.mainFrame.setJMenuBar(this.menuBar);
        this.mainFrame.setSize(300, 300);
        this.mainFrame.setLocation(0, 150);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                System.exit(0);
            }
        });
        this.myPanel = new JPanel();
        this.myPanel.setLayout(new GridLayout(1, 2));
        this.inputText = new JTextArea();
        this.outputText = new JTextArea();
        this.scrollPane1 = new JScrollPane(this.inputText);
        this.scrollPane2 = new JScrollPane(this.outputText);
        this.myPanel.add(this.scrollPane1);
        this.myPanel.add(this.scrollPane2);
        this.mainFrame.getContentPane().add((Component)this.myPanel, "Center");
        this.myJButtonJPanel = new JPanel();
        this.myJButtonJPanel.setLayout(new GridLayout(2, 2));
        this.mainFrame.getContentPane().add((Component)this.myJButtonJPanel, "South");
        this.refineJButton = new JButton("Refine Multiruns");
        this.refineJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MultirunRefiner.this.outputText.setText(MultirunRefiner.refineToText(MultirunRefiner.refine(MultirunRefiner.this.inputText.getText())));
            }
        });
        this.exitJButton = new JButton("EXIT");
        this.exitJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                System.exit(0);
            }
        });
        this.myJButtonJPanel.add(this.refineJButton);
        this.myJButtonJPanel.add(this.exitJButton);
        this.mainFrame.validate();
        this.mainFrame.setVisible(true);
    }

    public void loadFile() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Select a Multirun.TXT File");
        fc.setFileFilter(new TXTFileFilter());
        int returnVal = fc.showDialog(this.mainFrame, "Load Multirun.TXT");
        if (returnVal == 0) {
            this.readFile(fc.getSelectedFile());
            this.mainFrame.validate();
        }
    }

    protected boolean readFile(File f) {
        this.clearInputText();
        try {
            FileReader fileStream = new FileReader(f);
            this.inputText.read(fileStream, f);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.clearInputText();
            return false;
        }
    }

    public void clearInputText() {
        this.inputText.setText("");
    }

    public void clearOutputText() {
        this.outputText.setText("");
    }

    public void addOutputText(String t) {
        this.outputText.setText(this.outputText.getText() + t);
    }

    private void writeFile() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Select destination file");
        fc.setFileFilter(new TXTFileFilter());
        int returnVal = fc.showSaveDialog(this.mainFrame);
        if (returnVal == 0) {
            try {
                FileWriter fileStream = new FileWriter(fc.getSelectedFile());
                this.outputText.write(fileStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static boolean hasNextLine(String txt) {
        return txt != null && txt.length() > 0;
    }

    protected static String readLine(BufferedReader br) {
        String line;
        try {
            line = br.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return line;
    }

    public static ArrayList<double[]> refine(String text) {
        String line;
        double[] mean = new double[3];
        int numExp = 0;
        int iteration = 0;
        int lineCnt = 0;
        ArrayList<double[]> result = new ArrayList<double[]>();
        String runHeader = "Fun.calls \t Best \t Mean \t Worst \t Solution";
        String runFinalizer = " Best solution: ";
        boolean readRun = false;
        BufferedReader br = new BufferedReader(new StringReader(text));
        while ((line = MultirunRefiner.readLine(br)) != null) {
            ++lineCnt;
            if (line.startsWith(runHeader)) {
                ++numExp;
                readRun = true;
                iteration = 0;
                System.out.println("Experiment starts at line " + lineCnt);
                continue;
            }
            if (line.startsWith(runFinalizer)) {
                System.out.println("Experiment ends at line " + lineCnt);
                readRun = false;
                continue;
            }
            if (!readRun) continue;
            double[] tmp = MultirunRefiner.parseStringForDouble(line);
            if (tmp.length > 3) {
                if (numExp == 1) {
                    mean = new double[3];
                    result.add(iteration, mean);
                } else {
                    mean = (double[])result.get(iteration);
                }
                mean[0] = mean[0] + tmp[1];
                mean[1] = mean[1] + tmp[2];
                mean[2] = mean[2] + tmp[3];
            } else {
                System.err.println("Error in MultiRunRefiner!");
            }
            ++iteration;
        }
        System.out.println(lineCnt + " lines parsed. " + numExp + " experiments with " + result.size() + " events each.");
        for (int i = 0; i < result.size(); ++i) {
            mean = result.get(i);
            int k = 0;
            while (k < mean.length) {
                int n = k++;
                mean[n] = mean[n] / (double)numExp;
            }
        }
        return result;
    }

    public static String refineToText(ArrayList<double[]> result) {
        StringBuilder sbuf = new StringBuilder("Event\tBest\tMean\tWorst\n");
        for (int i = 0; i < result.size(); ++i) {
            double[] mean = result.get(i);
            sbuf.append(i + "\t" + mean[0] + "\t" + mean[1] + "\t" + mean[2] + "\n");
        }
        return sbuf.toString();
    }

    public static String refineToText(String input) {
        return MultirunRefiner.refineToText(MultirunRefiner.refine(input));
    }

    public static double[] parseStringForDouble(String searchme) {
        int positionInString = 0;
        boolean EndOfStringReached = false;
        if (searchme.startsWith("calls") || searchme == null) {
            double[] output = new double[]{};
            return output;
        }
        searchme = searchme.replace(',', '.');
        Vector<Double> tmpOutput = new Vector<Double>(10);
        int from = positionInString;
        int to = positionInString;
        int i = 0;
        while (to < searchme.length()) {
            while (to < searchme.length() - 1 && searchme.charAt(to) != '\t' && !Character.isSpaceChar(searchme.charAt(to)) && searchme.charAt(to) != '\n') {
                char tmp = searchme.charAt(to);
                ++to;
            }
            if (to < searchme.length()) {
                if (to == searchme.length() - 1) {
                    to = searchme.length();
                }
                String tmpString = searchme.substring(from, to);
                try {
                    tmpOutput.add(i, new Double(tmpString));
                    ++i;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            from = ++to;
        }
        double[] output = new double[i];
        for (int j = 0; j < i; ++j) {
            output[j] = (Double)tmpOutput.elementAt(j);
        }
        return output;
    }

    public static void main(String[] x) {
        MultirunRefiner universalprogram = new MultirunRefiner();
        universalprogram.starter();
    }
}

