/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools;

import eva2.gui.BeanInspector;
import eva2.tools.BasicResourceLoader;
import eva2.tools.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class ReflectPackage {
    private static final Logger LOGGER = Logger.getLogger(ReflectPackage.class.getName());
    static int missedJarsOnClassPath = 0;
    static boolean useFilteredClassPath = true;
    static String[] dynCP = null;

    public static int getClassesFromFilesFltr(HashSet<Class> set, String path, String pckgname, boolean includeSubs, Class reqSuperCls) {
        try {
            File directory = null;
            String dir = null;
            try {
                ClassLoader cld = ClassLoader.getSystemClassLoader();
                if (cld == null) {
                    throw new ClassNotFoundException("Can't get class loader.");
                }
                dir = path + "/" + pckgname.replace(".", "/");
                directory = new File(dir);
            }
            catch (NullPointerException x) {
                return 0;
            }
            if (directory.exists()) {
                return ReflectPackage.getClassesFromDirFltr(set, directory, pckgname, includeSubs, reqSuperCls);
            }
            return 0;
        }
        catch (ClassNotFoundException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return 0;
        }
    }

    public static int getClassesFromDirFltr(HashSet<Class> set, File directory, String pckgname, boolean includeSubs, Class<?> reqSuperCls) {
        int cntAdded = 0;
        if (directory.exists()) {
            String[] files;
            for (String file : files = directory.list()) {
                File subDir;
                if (file.endsWith(".class")) {
                    try {
                        Class<?> cls = Class.forName(pckgname + '.' + file.substring(0, file.length() - 6));
                        if (reqSuperCls != null) {
                            if (!reqSuperCls.isAssignableFrom(cls)) continue;
                            cntAdded += ReflectPackage.addClass(set, cls);
                            continue;
                        }
                        cntAdded += ReflectPackage.addClass(set, cls);
                    }
                    catch (Error | Exception e) {
                        System.err.println("ReflectPackage: Couldn't get Class from jar for " + pckgname + '.' + file + ": " + e.getMessage());
                    }
                    continue;
                }
                if (!includeSubs || !(subDir = new File(directory.getAbsolutePath() + File.separatorChar + file)).exists() || !subDir.isDirectory()) continue;
                cntAdded += ReflectPackage.getClassesFromDirFltr(set, subDir, pckgname + "." + file, includeSubs, reqSuperCls);
            }
        }
        return cntAdded;
    }

    public static void resetDynCP() {
        dynCP = null;
    }

    private static int addClass(HashSet<Class> set, Class cls) {
        if (set.contains(cls)) {
            LOGGER.warning("Class " + cls.getName() + " not added twice!");
            return 0;
        }
        set.add(cls);
        return 1;
    }

    public static ArrayList<Class> filterAssignableClasses(ArrayList<Class> classes, Class<?> reqSuperCls) {
        ArrayList<Class> assClasses = new ArrayList<Class>();
        for (Class aClass : classes) {
            if (!reqSuperCls.isAssignableFrom(aClass)) continue;
            assClasses.add(aClass);
        }
        return assClasses;
    }

    public static int getClassesFromJarFltr(HashSet<Class> set, String jarName, String packageName, boolean includeSubs, Class<?> reqSuperCls) {
        int cntAdded;
        block8: {
            boolean isInSubPackage = true;
            cntAdded = 0;
            packageName = packageName.replaceAll("\\.", "/");
            try {
                JarEntry jarEntry;
                JarInputStream jarFile = new JarInputStream(new FileInputStream(jarName));
                while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.startsWith(packageName) || !jarEntryName.endsWith(".class")) continue;
                    if (!includeSubs) {
                        int lastDash = jarEntryName.lastIndexOf(47);
                        boolean bl = isInSubPackage = lastDash > packageName.length() + 1;
                    }
                    if (!includeSubs && isInSubPackage) continue;
                    String clsName = jarEntryName.replace("/", ".");
                    try {
                        Class<?> cls = Class.forName(clsName.substring(0, jarEntryName.length() - 6));
                        if (reqSuperCls != null) {
                            if (!reqSuperCls.isAssignableFrom(cls)) continue;
                            cntAdded += ReflectPackage.addClass(set, cls);
                            continue;
                        }
                        cntAdded += ReflectPackage.addClass(set, cls);
                    }
                    catch (Error | Exception e) {
                        LOGGER.warning("ReflectPackage: Couldn't get Class from jar for " + clsName + ": " + e.getMessage());
                    }
                }
            }
            catch (IOException e) {
                if (++missedJarsOnClassPath == 0) {
                    LOGGER.warning("Couldn't open jar from class path. Dirty class path? " + e.getMessage());
                }
                if (missedJarsOnClassPath != 2) break block8;
                System.err.println("Couldn't open jar from class path more than once...");
            }
        }
        return cntAdded;
    }

    public static Class[] getAllClassesInPackage(String pkg, boolean includeSubs, boolean bSort) {
        return ReflectPackage.getClassesInPackageFltr(new HashSet<Class>(), pkg, includeSubs, bSort, null);
    }

    public static Class[] getClassesInPackageFltr(HashSet<Class> set, String pkg, boolean includeSubs, boolean bSort, Class reqSuperCls) {
        if (!useFilteredClassPath || dynCP == null) {
            if (useFilteredClassPath) {
                try {
                    dynCP = ReflectPackage.getValidCPArray();
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            } else {
                dynCP = ReflectPackage.getClassPathElements();
            }
        }
        for (String aDynCP : dynCP) {
            if (aDynCP.endsWith(".jar")) {
                int index = aDynCP.lastIndexOf(System.getProperty("file.separator"));
                if (index != -1 && !aDynCP.substring(index).toLowerCase().contains("eva")) {
                    LOGGER.fine("Skipping Jar (does not start with \"eva\": " + aDynCP);
                    continue;
                }
                ReflectPackage.getClassesFromJarFltr(set, aDynCP, pkg, includeSubs, reqSuperCls);
                continue;
            }
            ReflectPackage.getClassesFromFilesFltr(set, aDynCP, pkg, includeSubs, reqSuperCls);
        }
        Object[] clsArr = set.toArray();
        if (bSort) {
            Arrays.sort(clsArr, new ClassComparator());
        }
        List<Object> list = Arrays.asList(clsArr);
        return list.toArray(new Class[list.size()]);
    }

    public static String getResourcePathFromCP(String res) {
        String[] cpEntries = ReflectPackage.getClassPathElements();
        URL url = ClassLoader.getSystemResource(res);
        if (url != null) {
            File f;
            try {
                f = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                f = new File(url.getPath());
            }
            return f.getPath();
        }
        String fNameSep = res.startsWith(System.getProperty("file.separator")) ? res : System.getProperty("file.separator") + res;
        for (String cpEntry : cpEntries) {
            File f;
            if (cpEntry.endsWith(".jar") || !(f = new File(cpEntry + fNameSep)).exists()) continue;
            return f.getAbsolutePath();
        }
        return null;
    }

    public static InputStream getResourceStreamFromCP(String res) {
        InputStream in = BasicResourceLoader.getInstance().getStreamFromResourceLocation(res);
        if (in != null) {
            return in;
        }
        String[] cpEntries = ReflectPackage.getClassPathElements();
        String fNameSep = res.startsWith(System.getProperty("file.separator")) ? res : System.getProperty("file.separator") + res;
        for (String cpEntry : cpEntries) {
            File f;
            if (cpEntry.endsWith(".jar") || !(f = new File(cpEntry + fNameSep)).exists()) continue;
            try {
                return new FileInputStream(f);
            }
            catch (Exception e) {
                System.err.println("error reading file " + f.getAbsolutePath() + ": " + e.getMessage());
            }
        }
        return null;
    }

    public static ArrayList<String> getValidCPEntries() {
        String[] pathElements = ReflectPackage.getClassPathElements();
        ArrayList<String> valids = new ArrayList<String>(pathElements.length);
        for (String pathElement : pathElements) {
            File f = new File(pathElement);
            if (!f.exists() || !f.canRead()) continue;
            valids.add(pathElement);
        }
        return valids;
    }

    public static String[] getValidCPArray() {
        ArrayList<String> valids = ReflectPackage.getValidCPEntries();
        String[] vp = new String[valids.size()];
        for (int i = 0; i < valids.size(); ++i) {
            vp[i] = valids.get(i);
        }
        return vp;
    }

    public static Class<?>[] getAssignableClassesInPackage(String pckg, Class reqSuperCls, boolean includeSubs, boolean bSort) {
        return ReflectPackage.getClassesInPackageFltr(new HashSet<Class>(), pckg, includeSubs, bSort, reqSuperCls);
    }

    public static Class<?>[] getAssignableClasses(String pckgClassName, boolean includeSubs, boolean bSort) {
        Class<?>[] clsArr;
        int dotIndex = pckgClassName.lastIndexOf(46);
        if (dotIndex <= 0) {
            System.err.println("warning: " + pckgClassName + " is not a package!");
            return null;
        }
        String pckg = pckgClassName.substring(0, pckgClassName.lastIndexOf(46));
        try {
            clsArr = ReflectPackage.getAssignableClassesInPackage(pckg, Class.forName(pckgClassName), includeSubs, bSort);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            clsArr = null;
        }
        return clsArr;
    }

    public static void main(String[] args) {
        ClassLoader cld = Thread.currentThread().getContextClassLoader();
        System.out.println("1: " + cld.getResource("/eva2/optimization"));
        System.out.println("2: " + cld.getResource("eva2/optimization"));
        HashSet<String> h = new HashSet<String>(20);
        for (int i = 0; i < 20; ++i) {
            h.add("String " + i % 10);
        }
        for (String string : h) {
            System.out.println("+ " + string);
        }
    }

    public static String[] getClassPathElements() {
        String classPath = System.getProperty("java.class.path", ".");
        return classPath.split(File.pathSeparator);
    }

    public static Object getHotspotMBean() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectInstance bean = null;
        try {
            bean = server.getObjectInstance(new ObjectName("com.sun.management:type=HotSpotDiagnostic"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bean;
    }

    public static Object dumpHeap(String file, boolean live) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Object ret = null;
        try {
            server.invoke(new ObjectName("com.sun.management:type=HotSpotDiagnostic"), "dumpHeap", new Object[]{file, live}, new String[]{"java.lang.String", "boolean"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Object instantiateWithParams(String clsName, List<Pair<String, Object>> paramValuePairs) {
        return ReflectPackage.instantiateWithParams(clsName, new Object[0], paramValuePairs);
    }

    public static Object instantiateWithParams(String clsName, Object[] args, List<Pair<String, Object>> paramValuePairs) {
        Object o = ReflectPackage.getInstance(clsName, args);
        if (o != null) {
            if (paramValuePairs != null) {
                for (Pair<String, Object> nameVal : paramValuePairs) {
                    boolean succ = BeanInspector.setMem(o, (String)nameVal.head, nameVal.tail);
                    if (succ) continue;
                    System.err.println("Error, unable to set " + (String)nameVal.head + " to " + nameVal.tail + " in object " + o);
                    return null;
                }
            }
            return o;
        }
        System.err.println("Error in instantiateWithParams!");
        return null;
    }

    public static Object getInstance(String clsName, Object[] args) {
        Object o;
        try {
            Class<?> clz = Class.forName(clsName);
            Class[] argClz = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argClz[i] = args[i].getClass();
            }
            try {
                Constructor<?> ct = clz.getConstructor(argClz);
                o = ct.newInstance(args);
            }
            catch (Exception e) {
                System.err.println("Unable to retrieve constructor of " + clsName + ", arguments " + BeanInspector.toString(args) + "\n" + e.getClass());
                System.err.println(e.getMessage());
                e.printStackTrace();
                o = null;
            }
        }
        catch (Exception e) {
            System.err.println("Unable to create instance of " + clsName + ", arguments " + BeanInspector.toString(args) + "\n" + e.getMessage());
            e.printStackTrace(System.err);
            o = null;
        }
        return o;
    }

    static class ClassComparator<T>
    implements Comparator<T> {
        ClassComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

