/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools;

import eva2.tools.Tag;
import java.io.Serializable;

public class SelectedTag
implements Serializable {
    protected int selectedId;
    protected Tag[] tags;

    public Object clone() {
        SelectedTag result = new SelectedTag(this.selectedId, this.tags);
        return result;
    }

    public SelectedTag(String ... strings) {
        this.init(0, strings);
    }

    public SelectedTag(int selID, String ... strings) {
        this.init(selID, strings);
    }

    public SelectedTag(int selID, Tag[] tags) {
        this.tags = tags;
        this.selectedId = -1;
        for (int i = 0; i < tags.length; ++i) {
            if (i != tags[i].getID()) {
                System.err.println("warning, SelectedTag with inconsistent ID, this may cause problems");
            }
            if (tags[i].getID() != selID) continue;
            this.selectedId = i;
        }
        if (this.selectedId == -1) {
            throw new IllegalArgumentException("Selected tag is not valid");
        }
    }

    private void init(int selID, String[] tagStrings) {
        this.tags = new Tag[tagStrings.length];
        this.selectedId = -1;
        for (int i = 0; i < this.tags.length; ++i) {
            this.tags[i] = new Tag(i, tagStrings[i]);
            if (selID != i) continue;
            this.selectedId = i;
        }
        if (this.selectedId == -1) {
            throw new IllegalArgumentException("Selected tag is not valid");
        }
    }

    public SelectedTag setSelectedTag(int i) {
        if (i >= 0 && i < this.tags.length) {
            this.selectedId = i;
        }
        return this;
    }

    public SelectedTag setSelectedTag(String str) {
        for (int i = 0; i < this.tags.length; ++i) {
            if (this.tags[i].text.compareTo(str) != 0) continue;
            this.selectedId = i;
            return this;
        }
        System.err.println("Warning, trying to select unknown string (SelectedTag::setSelectedTag(String)");
        return this;
    }

    public void setSelectedAs(SelectedTag o) {
        this.setSelectedTag(o.getSelectedTag().getID());
    }

    public Tag getSelectedTag() {
        return this.tags[this.selectedId];
    }

    public int getSelectedTagID() {
        return this.tags[this.selectedId].getID();
    }

    public String getSelectedString() {
        return this.tags[this.selectedId].getString();
    }

    public int getTagIDByString(String str) {
        for (int i = 0; i < this.tags.length; ++i) {
            if (!this.tags[i].equals(str)) continue;
            return this.tags[i].getID();
        }
        return -1;
    }

    public boolean isSelectedString(String str) {
        return str.equals(this.getSelectedTag().getString());
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        SelectedTag s = (SelectedTag)o;
        return s.getTags() == this.tags && s.getSelectedTag() == this.tags[this.selectedId];
    }

    public boolean hasSameTags(SelectedTag selT) {
        Tag[] oTags = selT.getTags();
        if (oTags.length != this.tags.length) {
            return false;
        }
        for (int i = 0; i < oTags.length; ++i) {
            if (oTags[i].getString().compareTo(this.tags[i].getString()) == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.tags[this.selectedId].getString();
    }
}

