/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SerializedObject
implements Serializable {
    private byte[] serializedBytes;
    private boolean isCompressed;

    public SerializedObject(Object obj) throws IOException {
        this(obj, false);
    }

    public SerializedObject(Object obj, boolean compress) throws IOException {
        this.isCompressed = compress;
        this.serializedBytes = SerializedObject.toByteArray(obj, this.isCompressed);
    }

    protected static byte[] toByteArray(Object obj, boolean compress) throws IOException {
        ByteArrayOutputStream bo;
        OutputStream os = bo = new ByteArrayOutputStream();
        if (compress) {
            os = new GZIPOutputStream(os);
        }
        os = new BufferedOutputStream(os);
        ObjectOutputStream oo = new ObjectOutputStream(os);
        oo.writeObject(obj);
        oo.close();
        return bo.toByteArray();
    }

    public Object getObject() throws IOException, ClassNotFoundException {
        InputStream is = new ByteArrayInputStream(this.serializedBytes);
        if (this.isCompressed) {
            is = new GZIPInputStream(is);
        }
        is = new BufferedInputStream(is);
        ObjectInputStream oi = new ObjectInputStream(is);
        Object result = oi.readObject();
        oi.close();
        return result;
    }

    public final boolean equals(Object other) {
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        byte[] os = ((SerializedObject)other).serializedBytes;
        if (os.length != this.serializedBytes.length) {
            return false;
        }
        for (int i = 0; i < this.serializedBytes.length; ++i) {
            if (this.serializedBytes[i] == os[i]) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        return this.serializedBytes.length;
    }

    public String toString() {
        return (this.isCompressed ? "Compressed object: " : "Uncompressed object: ") + this.serializedBytes.length + " bytes";
    }
}

