/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools;

import eva2.tools.SerializedObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Serializer {
    private static final Logger LOGGER = Logger.getLogger(Serializer.class.getName());

    private Serializer() {
    }

    private static void store(Serializable o, OutputStream outStream, boolean serializeInMem) throws IOException {
        ObjectOutputStream objectStream = new ObjectOutputStream(outStream);
        try {
            Serializable objToStore = o;
            if (serializeInMem) {
                objToStore = new SerializedObject(o);
            }
            objectStream.writeObject(objToStore);
            objectStream.flush();
            objectStream.close();
        }
        catch (NotSerializableException ex) {
            LOGGER.log(Level.SEVERE, "Object is not serializable!", ex);
        }
    }

    private static Object load(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objInputStream = new ObjectInputStream(inputStream);
        Object ret = objInputStream.readObject();
        if (ret instanceof SerializedObject) {
            ret = ((SerializedObject)ret).getObject();
        }
        objInputStream.close();
        return ret;
    }

    public static Object deepClone(Object o) {
        Object obj = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(o);
            out.flush();
            out.close();
            ObjectInputStream inputStream = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            obj = inputStream.readObject();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Error while cloning object.", ex);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.WARNING, "Object class was not found.", ex);
        }
        return obj;
    }

    public static void storeString(OutputStream outStream, String data) {
        try {
            outStream.write(data.getBytes());
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Could not write string to stream", ex);
        }
    }

    public static String loadString(InputStream inputStream) {
        StringBuilder sBuilder = new StringBuilder();
        try {
            int data = inputStream.read();
            while (data != -1) {
                sBuilder.append((char)data);
                data = inputStream.read();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Could not load string from stream!", ex);
        }
        return sBuilder.toString();
    }

    public static void storeObject(OutputStream outStream, Serializable s) {
        try {
            Serializer.store(s, outStream, true);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINER, "Could not write object to stream.", ex);
        }
    }

    public static Object loadObject(InputStream inputStream) {
        return Serializer.loadObject(inputStream, true);
    }

    public static Object loadObject(InputStream inputStream, boolean casually) {
        Object serializedObject = null;
        try {
            serializedObject = Serializer.load(inputStream);
        }
        catch (InvalidClassException ex) {
            LOGGER.log(Level.WARNING, "Could not load object file.", ex);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.WARNING, "Matching object class could not be found.", ex);
        }
        catch (Exception ex) {
            if (!casually) {
                throw new RuntimeException("WARNING: loading object is not possible! (" + ex.getMessage() + ")");
            }
            return null;
        }
        return serializedObject;
    }
}

