/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools;

import eva2.gui.BeanInspector;
import eva2.tools.Pair;
import eva2.tools.ToolBox;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class StringSelection
implements Serializable {
    private String[] strObjects;
    private String[] toolTips;
    boolean[] selStates;
    private transient HashMap<String, Integer> stringToIndexHash = null;
    private transient Class<? extends Enum> enumClass = null;

    public StringSelection(String[] sArr, String[] tips) {
        this.strObjects = sArr;
        this.toolTips = tips;
        this.selStates = new boolean[sArr.length];
        this.stringToIndexHash = null;
        this.enumClass = null;
    }

    public StringSelection(String[] sArr, String[] tips, int initialSel) {
        this(sArr, tips);
        if (initialSel < this.getLength()) {
            this.setSelected(initialSel, true);
        }
        this.enumClass = null;
    }

    public StringSelection(Enum<?> e, String[] tips) {
        this.strObjects = new String[((Enum[])e.getClass().getEnumConstants()).length];
        this.toolTips = tips;
        this.selStates = new boolean[this.strObjects.length];
        for (int i = 0; i < this.strObjects.length; ++i) {
            this.strObjects[i] = ((Enum[])e.getClass().getEnumConstants())[i].toString();
        }
        this.setSelected(e.ordinal(), true);
        this.stringToIndexHash = null;
        this.enumClass = e.getClass();
    }

    public StringSelection(StringSelection stringSelection) {
        this.strObjects = (String[])stringSelection.strObjects.clone();
        this.selStates = (boolean[])stringSelection.selStates.clone();
        this.toolTips = (String[])stringSelection.toolTips.clone();
        this.stringToIndexHash = null;
        this.enumClass = stringSelection.enumClass;
    }

    public StringSelection(Enum<?> e, String[] enumTips, List<String> headerFields, String[] addTips) {
        this(ToolBox.appendEnumAndArray(e, headerFields.toArray(new String[headerFields.size()])), ToolBox.appendArrays(enumTips, new String[][]{addTips}));
        this.enumClass = e.getClass();
    }

    public Object clone() {
        return new StringSelection(this);
    }

    public int getLength() {
        return this.strObjects.length;
    }

    public String getElement(int i) {
        return this.strObjects[i];
    }

    public String getElementInfo(int i) {
        if (this.toolTips != null && this.toolTips.length > i) {
            return this.toolTips[i];
        }
        return null;
    }

    public String[] getStrings() {
        return this.strObjects;
    }

    public boolean isSelected(int i) {
        try {
            return this.selStates[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(e.getMessage() + " - inconsistent implementation of InterfaceAdditionalPopulationInformer?");
        }
    }

    public boolean isSelected(Enum<?> e) {
        if (this.enumClass != null) {
            if (e.getClass().equals(this.enumClass)) {
                return this.isSelected(e.ordinal());
            }
            System.err.println("Error, the string selection was constructed with a different enum class - invalid request (StringSelection.isSelected(Enum)");
            return false;
        }
        System.err.println("Error, the string selection was constructed without an enum class - invalid request (StringSelection.isSelected(Enum)");
        return false;
    }

    public boolean isSelected(String str) {
        Integer selIndex;
        if (this.stringToIndexHash == null) {
            this.stringToIndexHash = new HashMap(2 * this.strObjects.length);
            for (int i = 0; i < this.strObjects.length; ++i) {
                this.stringToIndexHash.put(this.strObjects[i], i);
            }
        }
        if ((selIndex = this.stringToIndexHash.get(str)) == null) {
            System.err.println("Error, unknown string for StringSelection: " + str + ", selectable were " + BeanInspector.toString(this.getStrings()));
            return false;
        }
        return this.isSelected(selIndex);
    }

    public int stringToIndex(String str) {
        Integer selIndex;
        if (this.stringToIndexHash == null) {
            this.stringToIndexHash = new HashMap(2 * this.strObjects.length);
            for (int i = 0; i < this.strObjects.length; ++i) {
                this.stringToIndexHash.put(this.strObjects[i], i);
            }
        }
        if ((selIndex = this.stringToIndexHash.get(str)) == null) {
            return -1;
        }
        return selIndex;
    }

    public void setSelected(String str, boolean v) {
        int index = this.stringToIndex(str);
        if (index >= 0) {
            this.setSelected(index, v);
        } else {
            System.err.println("Error, unknown string " + str + " can't be selected in " + this.getClass());
        }
    }

    public void setSelected(int i, boolean v) {
        this.selStates[i] = v;
    }

    public void toggleSelected(int i) {
        this.selStates[i] = !this.selStates[i];
    }

    public void takeOverSelection(StringSelection sel) {
        int i;
        int mismatchAt = -1;
        for (i = 0; i < sel.getLength() && i < this.getLength(); ++i) {
            if (!sel.getElement(i).equals(this.getElement(i))) {
                mismatchAt = i;
                break;
            }
            this.setSelected(i, sel.isSelected(i));
        }
        if (mismatchAt >= 0) {
            for (i = mismatchAt; i < this.getLength(); ++i) {
                for (int j = mismatchAt; j < sel.getLength(); ++j) {
                    if (!sel.getElement(j).equals(this.getElement(i))) continue;
                    this.setSelected(i, sel.isSelected(j));
                }
            }
        }
    }

    public String[] getSelected() {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < this.getLength(); ++i) {
            if (!this.isSelected(i)) continue;
            ret.add(this.getElement(i));
        }
        return ret.toArray(new String[ret.size()]);
    }

    public List<Pair<String, Integer>> getSelectedWithIndex() {
        ArrayList<Pair<String, Integer>> ret = new ArrayList<Pair<String, Integer>>();
        for (int i = 0; i < this.getLength(); ++i) {
            if (!this.isSelected(i)) continue;
            ret.add(new Pair<String, Integer>(this.getElement(i), i));
        }
        return ret;
    }

    public Enum[] getSelectedEnum(Enum[] e) {
        LinkedList<Integer> selectedList = new LinkedList<Integer>();
        for (int i = 0; i < e.length; ++i) {
            if (!this.isSelected(e[i])) continue;
            selectedList.add(i);
        }
        Enum[] ret = (Enum[])Array.newInstance(e[0].getClass(), selectedList.size());
        Iterator iter = selectedList.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ret[i++] = e[(Integer)iter.next()];
        }
        return ret;
    }

    public void setAllSelectionStates(boolean selState) {
        for (int i = 0; i < this.selStates.length; ++i) {
            this.selStates[i] = selState;
        }
    }
}

