/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools;

import eva2.gui.BeanInspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringTools {
    private StringTools() {
    }

    public static String toHTML(String string, int lineBreak) {
        StringTokenizer sTok = new StringTokenizer(string, " ");
        if (!sTok.hasMoreTokens()) {
            return "<html><body></body></html>";
        }
        StringBuilder sBuf = new StringBuilder(sTok.nextToken());
        int length = sBuf.length();
        while (sTok.hasMoreElements()) {
            if (length >= lineBreak) {
                sBuf.append("<br>");
                length = 0;
            } else {
                sBuf.append(" ");
            }
            String tmp = sTok.nextToken();
            length += tmp.length() + 1;
            sBuf.append(tmp);
        }
        sBuf.insert(0, "<html><body>");
        sBuf.append("</body></html>");
        return sBuf.toString();
    }

    public static boolean arrayContains(String[] arr, String key, boolean ignoreCase) {
        return StringTools.searchStringArray(arr, key, 0, ignoreCase) >= 0;
    }

    public static String expandPrefixZeros(int index, int maxSize) {
        if (maxSize < 10) {
            return "" + index;
        }
        if (maxSize < 100) {
            return (index < 10 ? "0" : "") + index;
        }
        int lenZeros = (int)Math.log10(maxSize) - (int)Math.log10(index);
        char[] zerArr = new char[lenZeros];
        Arrays.fill(zerArr, '0');
        return new String(zerArr) + index;
    }

    public static int searchStringArray(String[] arr, String key, int startIndex, boolean ignoreCase) {
        for (int i = startIndex; i < arr.length; ++i) {
            if (!(ignoreCase ? arr[i].equalsIgnoreCase(key) : arr[i].equals(key))) continue;
            return i;
        }
        return -1;
    }

    public static Integer[] parseArguments(String[] args, String[] keys, int[] arities, Object[] values, boolean ignoreCase) {
        LinkedList<Integer> unrecogs = new LinkedList<Integer>();
        for (int i = 0; i < args.length; ++i) {
            boolean found = false;
            for (int k = 0; k < keys.length && !found && i < args.length; ++k) {
                if ((!ignoreCase || !args[i].equalsIgnoreCase(keys[k])) && (ignoreCase || !args[i].equals(keys[k]))) continue;
                found = true;
                if (arities[k] == 0) {
                    values[k] = "true";
                    continue;
                }
                try {
                    if (arities[k] == 1) {
                        values[k] = args[i + 1];
                    } else {
                        values[k] = new String[arities[k]];
                        if (arities[k] > 0) {
                            for (int j = 0; j < arities[k]; ++j) {
                                ((String[])values[k])[j] = args[i + j + 1];
                            }
                            i += arities[k] - 1;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    String errMsg = "Not enough parameters for option " + keys[k] + ", expected number of arguments: " + arities[k];
                    System.err.println(errMsg);
                    throw new RuntimeException(errMsg);
                }
                ++i;
            }
            if (found) continue;
            unrecogs.add(i);
        }
        return unrecogs.toArray(new Integer[unrecogs.size()]);
    }

    public static HashMap<String, Object> parseArguments(String[] args, String[] keys, int[] arities, boolean ignoreCase, boolean printErrorsOnUnrecog) {
        Object[] values = new Object[keys.length];
        Integer[] unrecogs = StringTools.parseArguments(args, keys, arities, values, ignoreCase);
        if (printErrorsOnUnrecog && unrecogs.length > 0) {
            System.err.println("Unrecognized command line options: ");
            for (int i = 0; i < unrecogs.length; ++i) {
                System.err.println("   " + args[unrecogs[i]]);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static String checkSingleStringArg(String key, Object object, int i) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            if (i == 0) {
                return (String)object;
            }
            System.err.println("Invalid argument; cannot access element " + i + " for " + key + " as only one was given.");
            return null;
        }
        if (object instanceof String[]) {
            String[] arr = (String[])object;
            if (i < arr.length) {
                return arr[i];
            }
            System.err.println("Not enough arguments for " + key);
            return null;
        }
        System.err.println("Invalid argument; " + key + " " + BeanInspector.toString(object));
        return null;
    }

    public static String wrapLine(String str, int len, double tolerancePerCent) {
        return StringTools.wrapLine(str, new char[]{' ', '-', ',', '.'}, len, tolerancePerCent);
    }

    public static String wrapLine(String str, char[] breakChars, int len, double tolerancePerCent) {
        StringBuffer res = new StringBuffer();
        String rest = str;
        int minLen = (int)((1.0 - tolerancePerCent) * (double)len);
        int maxLen = (int)((1.0 + tolerancePerCent) * (double)len);
        while (rest.length() > 0) {
            int nextBreak;
            if (rest.length() <= maxLen) {
                nextBreak = rest.length() - 1;
            } else {
                nextBreak = StringTools.getNextBreak(minLen, maxLen, breakChars, rest);
                if (nextBreak < 0) {
                    nextBreak = len;
                }
            }
            if (res.length() > 0) {
                res.append("\n");
            }
            res.append(rest.substring(0, nextBreak + 1));
            rest = rest.substring(nextBreak + 1);
        }
        return res.toString();
    }

    public static int getNextBreak(int startIndex, int endIndex, char[] brkChars, String str) {
        for (int i = 0; i < brkChars.length; ++i) {
            int index = str.indexOf("" + brkChars[i], startIndex);
            if (index < 0 || index > endIndex) continue;
            return index;
        }
        return -1;
    }

    public static String concatFields(List<String> strings, String delim) {
        StringBuilder sBuilder = new StringBuilder();
        int cnt = 0;
        for (String field : strings) {
            if (cnt > 0) {
                sBuilder.append(delim);
            }
            sBuilder.append(field);
            ++cnt;
        }
        return sBuilder.toString();
    }

    public static String concatValues(List<Object> objects, String delim) {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (Object v : objects) {
            if (cnt > 0) {
                sb.append(delim);
            }
            sb.append(BeanInspector.toString(v));
            ++cnt;
        }
        return sb.toString();
    }

    public static String concatFields(String[] strs, String delim) {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (String str : strs) {
            if (cnt > 0) {
                sb.append(delim);
            }
            sb.append(str);
            ++cnt;
        }
        return sb.toString();
    }

    public static String simplifySymbols(String str) {
        char[] toRemove;
        char[] toDash;
        char[] toUnderscore;
        for (char c : toUnderscore = new char[]{' ', '\t', '\n'}) {
            str = str.replace(c, '_');
        }
        for (char c : toDash = new char[]{',', ';', '/', '\\'}) {
            str = str.replace(c, '-');
        }
        for (char c : toRemove = new char[]{')', '(', '[', ']', '{', '}', '*'}) {
            str = StringTools.deleteChar(c, str);
        }
        str = str.replaceAll("--", "-");
        str = str.replaceAll("__", "_");
        str = str.replaceAll("-_", "_");
        str = str.replaceAll("_-", "_");
        return str;
    }

    public static String deleteChar(char c, String str) {
        StringBuilder sBuilder = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (c == str.charAt(i)) continue;
            sBuilder.append(str.charAt(i));
        }
        return sBuilder.toString();
    }

    public static String getSubstringAfterLast(String str, char c) {
        int p = str.lastIndexOf(c);
        return str.substring(p + 1);
    }

    public static String humaniseCamelCase(String word) {
        Pattern pattern = Pattern.compile("([A-Z]|[a-z])[a-z0-9]*");
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher matcher = pattern.matcher(word);
        String acronym = "";
        while (matcher.find()) {
            String found = matcher.group();
            if (found.matches("^[A-Z]$")) {
                acronym = acronym + found;
                continue;
            }
            if (acronym.length() > 0) {
                tokens.add(acronym);
                acronym = "";
            }
            tokens.add(StringTools.upcaseFirst(found));
        }
        if (acronym.length() > 0) {
            tokens.add(acronym);
        }
        if (!tokens.isEmpty()) {
            return StringTools.concatFields(tokens, " ");
        }
        return StringTools.upcaseFirst(word);
    }

    public static String convertToUnderscore(String word) {
        Pattern pattern = Pattern.compile("([A-Z]|[a-z])[a-z]*");
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher matcher = pattern.matcher(word);
        String acronym = "";
        while (matcher.find()) {
            String found = matcher.group();
            if (found.matches("^[A-Z]$")) {
                acronym = acronym + found;
                continue;
            }
            if (acronym.length() > 0) {
                tokens.add(acronym);
                acronym = "";
            }
            tokens.add(found);
        }
        if (acronym.length() > 0) {
            tokens.add(acronym);
        }
        if (!tokens.isEmpty()) {
            return StringTools.concatFields(tokens, "-").toLowerCase();
        }
        return word.toLowerCase();
    }

    public static String upcaseFirst(String word) {
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }

    public static String cutClassName(String value) {
        int dotPos = value.lastIndexOf(46);
        String className = value;
        if (dotPos != -1) {
            className = className.substring(dotPos + 1);
        }
        return className;
    }

    public static String translateGreek(String name) {
        String[][] mapping;
        for (String[] map : mapping = new String[][]{{"alpha", "\u03b1"}, {"beta", "\u03b2"}, {"gamma", "\u03b3"}, {"gammab", "\u0393"}, {"delta", "\u03b4"}, {"deltab", "\u0394"}, {"epsi", "epsilon", "\u03b5"}, {"zeta", "\u03b6"}, {"theta", "\u03d1"}, {"thetab", "\u0398"}, {"iota", "\u03b9"}, {"kappa", "\u03ba"}, {"lambda", "\u03bb"}, {"lambdab", "\u039b"}, {"rho", "\u03c1"}, {"sigma", "\u03c3"}, {"sigmab", "\u03a3"}, {"tau", "\u03c4"}, {"upsilon", "\u03c5"}, {"upsilonb", "\u03d2"}, {"omega", "\u03c9"}, {"omegab", "\u03a9"}, {"eta", "\u03b7"}, {"psi", "\u03c8"}, {"psib", "\u03a8"}, {"phi", "\u03d5"}, {"phib", "\u03a6"}, {"chi", "\u03c7"}, {"mu", "my", "myu", "\u03bc"}, {"nu", "\u03bd"}, {"xi", "\u03be"}, {"xib", "\u039e"}, {"pi", "\u03c0"}, {"pib", "\u03a0"}}) {
            for (int i = 0; i < map.length - 1; ++i) {
                Pattern p = Pattern.compile("^" + map[i] + "\\d*", 2);
                Matcher m = p.matcher(name);
                if (!m.matches()) continue;
                Pattern replace = Pattern.compile("^" + map[i], 2);
                Matcher rm = replace.matcher(name);
                return rm.replaceFirst(map[map.length - 1]);
            }
        }
        return name;
    }

    public static String subscriptIndices(String label) {
        Pattern p = Pattern.compile("(\\d+)$");
        Matcher m = p.matcher(label);
        return m.replaceFirst("<sub>$1</sub>");
    }
}

