/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools;

import eva2.gui.BeanInspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ToolBox {
    private ToolBox() {
    }

    public static String[] appendEnumAndArray(Enum<?> e, String[] additionalValues) {
        Enum[] fields = (Enum[])e.getClass().getEnumConstants();
        int enumLen = fields.length;
        int len = enumLen + additionalValues.length;
        String[] ret = new String[len];
        for (int i = 0; i < enumLen; ++i) {
            ret[i] = fields[i].toString();
        }
        System.arraycopy(additionalValues, 0, ret, enumLen, ret.length - enumLen);
        return ret;
    }

    public static <T> T[] appendArrays(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static Double[] parseDoubles(List<Object> l) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (Object o : l) {
            values.add(ToolBox.toDouble(o));
        }
        return values.toArray(new Double[values.size()]);
    }

    public static Double toDouble(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        try {
            return Double.parseDouble(BeanInspector.toString(o));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Double[] parseDoubles(Object[] os) {
        Double[] vals = new Double[os.length];
        for (int i = 0; i < os.length; ++i) {
            vals[i] = ToolBox.toDouble(os[i]);
        }
        return vals;
    }

    public static double[][] filterBy(double[][] dat, int i, double lower, double upper) {
        if (dat == null || dat.length == 0) {
            return dat;
        }
        if (i >= dat[0].length) {
            System.err.println("Error, invalid column index " + i + " for data array with " + dat[0].length + " columns!");
        }
        ArrayList<double[]> matching = new ArrayList<double[]>(5);
        for (double[] row : dat) {
            if (!(row[i] <= upper) || !(row[i] >= lower)) continue;
            matching.add(row);
        }
        return (double[][])matching.toArray((T[])new double[matching.size()][dat[0].length]);
    }

    public static double[][] getCols(double[][] data, int ... cols) {
        if (data == null || data[0] == null) {
            return null;
        }
        int nCols = cols.length;
        if (nCols > data[0].length) {
            System.err.println("Error, mismatching column count in Mathematics.getCols!");
        }
        double[][] ret = new double[data.length][cols.length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                ret[i][j] = data[i][cols[j]];
            }
        }
        return ret;
    }
}

