/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.chart2d;

import eva2.tools.chart2d.DBorder;
import eva2.tools.chart2d.DContainer;
import eva2.tools.chart2d.DElement;
import eva2.tools.chart2d.DFunction;
import eva2.tools.chart2d.DGrid;
import eva2.tools.chart2d.DMeasures;
import eva2.tools.chart2d.DParent;
import eva2.tools.chart2d.DRectangle;
import eva2.tools.chart2d.ScaledBorder;
import eva2.tools.chart2d.SlimRect;
import eva2.tools.print.PagePrinter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class DArea
extends JComponent
implements DParent,
Printable {
    public static final DRectangle DEFAULT_MIN_RECT = new DRectangle(-1.0, -1.0, 2.0, 2.0);
    private static final long serialVersionUID = 1461387400381365146L;
    private boolean autoFocus = false;
    private boolean autoGrid = false;
    private boolean gridToFront = false;
    private DContainer container;
    private DBorder dborder = new DBorder();
    private DGrid grid;
    private int maxGrid = 10;
    protected DMeasures measures;
    protected DRectangle minRect = DEFAULT_MIN_RECT;
    protected DRectangle visibleRect = DEFAULT_MIN_RECT;
    protected Double minX;
    protected Double minY;
    protected Double maxX;
    protected Double maxY;

    public DArea() {
        this(10);
    }

    public DArea(int initialCapacity) {
        this.container = new DContainer();
        this.container.setDParent(this);
        this.grid = new DGrid(this.visibleRect, 1.0, 1.0);
        this.grid.setVisible(false);
        this.grid.setDParent(this);
        this.measures = new DMeasures(this);
    }

    @Override
    public void addDBorder(DBorder b) {
        this.dborder.insert(b);
    }

    @Override
    public void addDElement(DElement e) {
        this.container.addDElement(e);
    }

    @Override
    public boolean contains(DElement e) {
        return this.container.contains(e);
    }

    public DBorder getDBorder() {
        return this.dborder;
    }

    @Override
    public DElement[] getDElements() {
        return this.container.getDElements();
    }

    public DMeasures getDMeasures() {
        return this.measures;
    }

    public DRectangle getDRectangle() {
        DRectangle rect = (DRectangle)this.visibleRect.clone();
        if (this.minX != null) {
            rect.setX(Math.max(rect.getX(), this.getMinX()));
        }
        if (this.minY != null) {
            rect.setY(Math.max(rect.getY(), this.getMinY()));
        }
        if (this.maxX != null) {
            rect.setWidth(Math.min(rect.getWidth(), this.getMaxX() - this.getMinX()));
        }
        if (this.maxY != null) {
            rect.setHeight(Math.min(rect.getHeight(), this.getMaxY() - this.getMinY()));
        }
        return rect;
    }

    public DRectangle getMaxRectangle() {
        return new DRectangle(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    public double getMaxX() {
        if (this.maxX != null) {
            return this.maxX;
        }
        return 0.0;
    }

    public double getMaxY() {
        if (this.maxY != null) {
            return this.maxY;
        }
        return 0.0;
    }

    public DRectangle getMinRectangle() {
        return (DRectangle)this.minRect.clone();
    }

    public double getMinX() {
        if (this.minX != null) {
            return this.minX;
        }
        return 0.0;
    }

    public double getMinY() {
        if (this.minY != null) {
            return this.minY;
        }
        return 0.0;
    }

    public SlimRect getSlimRectangle() {
        SlimRect srect = new SlimRect(this.visibleRect.getX(), this.visibleRect.getY(), this.visibleRect.getWidth(), this.visibleRect.getHeight());
        if (this.minX != null) {
            srect.x = Math.max(srect.x, this.getMinX());
        }
        if (this.minY != null) {
            srect.y = Math.max(srect.y, this.getMinY());
        }
        if (this.maxX != null) {
            srect.width = Math.min(srect.width, this.getMaxX() - this.getMinX());
        }
        if (this.maxY != null) {
            srect.height = Math.min(srect.height, this.getMaxY() - this.getMinY());
        }
        return srect;
    }

    public DFunction getYScale() {
        return this.measures.yScale;
    }

    public boolean hasAutoGrid() {
        return this.autoGrid;
    }

    public boolean isGridVisible() {
        return this.grid.isVisible();
    }

    public boolean isOnAutoFocus() {
        return this.autoFocus;
    }

    public boolean isShowGrid() {
        return this.grid.isVisible();
    }

    public void toggleShowGrid() {
        this.grid.toggleVisible();
    }

    @Override
    public void paint(Graphics g) {
        if (this.autoFocus) {
            this.container.restore();
            this.visibleRect = (DRectangle)this.container.getRectangle().clone();
        }
        if (this.visibleRect.isEmpty()) {
            this.visibleRect = (DRectangle)this.minRect.clone();
        }
        super.paint(g);
        this.measures.setGraphics(g);
        if (this.grid.isVisible() && !this.gridToFront) {
            this.paintGrid(this.measures);
        }
        this.container.paint(this.measures);
        if (this.grid.isVisible() && this.gridToFront) {
            this.paintGrid(this.measures);
        }
    }

    private void paintGrid(DMeasures m) {
        this.grid.rectangle = this.getDRectangle();
        if (this.autoGrid) {
            Border b = this.getBorder();
            if (b instanceof ScaledBorder) {
                ScaledBorder sb = (ScaledBorder)b;
                this.paintGrid(sb, m);
                return;
            }
            this.grid.setDistances(ScaledBorder.aBitBigger(this.grid.rectangle.getWidth() / (double)this.maxGrid), ScaledBorder.aBitBigger(this.grid.rectangle.getHeight() / (double)this.maxGrid));
        }
        this.grid.paint(m);
    }

    private void paintGrid(ScaledBorder sb, DMeasures m) {
        Dimension d = this.getSize();
        FontMetrics fm = m.getGraphics().getFontMetrics();
        this.grid.setDistances(sb.getSrcdX(fm, d), sb.getSrcdY(fm, d));
        if (m.xScale == null && m.yScale == null) {
            this.grid.paint(m);
        } else {
            Point p2;
            Point p1;
            double pos;
            Graphics g = m.g;
            g.setColor(this.grid.getColor());
            SlimRect rect = this.getSlimRectangle();
            SlimRect src_rect = m.getSourceOf(rect);
            int x = (int)(src_rect.x / this.grid.getHorDist());
            int y = (int)(src_rect.y / this.grid.getVerDist());
            if ((double)x * this.grid.getHorDist() < src_rect.x) {
                ++x;
            }
            if ((double)y * this.grid.getVerDist() < src_rect.y) {
                ++y;
            }
            double minx = rect.x;
            double miny = rect.y;
            double maxx = minx + rect.width;
            double maxy = miny + rect.height;
            while (true) {
                double d2;
                pos = (double)x * this.grid.getHorDist();
                if (!(d2 < src_rect.x + src_rect.width)) break;
                if (m.xScale != null) {
                    pos = m.xScale.getImageOf(pos);
                }
                p1 = m.getPoint(pos, miny);
                p2 = m.getPoint(pos, maxy);
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
                ++x;
            }
            while (true) {
                double d3;
                pos = (double)y * this.grid.getVerDist();
                if (!(d3 < src_rect.y + src_rect.height)) break;
                if (m.yScale != null) {
                    pos = m.yScale.getImageOf(pos);
                }
                p1 = m.getPoint(minx, pos);
                p2 = m.getPoint(maxx, pos);
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
                ++y;
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) {
        if (pi > 0) {
            return 1;
        }
        Border sb = this.getBorder();
        if (!(sb instanceof ScaledBorder)) {
            sb = null;
        } else {
            ((ScaledBorder)sb).showOuterBorder = false;
        }
        PagePrinter printer = new PagePrinter(this, g, pf);
        int ret = printer.print();
        if (sb != null) {
            ((ScaledBorder)sb).showOuterBorder = true;
        }
        return ret;
    }

    public void releaseMaxX() {
        this.maxX = null;
    }

    public void releaseMaxY() {
        this.maxY = null;
    }

    public void releaseMinX() {
        this.minX = null;
    }

    public void releaseMinY() {
        this.minY = null;
    }

    public void removeAllDElements() {
        this.visibleRect = (DRectangle)this.minRect.clone();
        this.container.removeAllDElements();
    }

    @Override
    public boolean removeDElement(DElement e) {
        return this.container.removeDElement(e);
    }

    @Override
    public void repaint(DRectangle r) {
        if (r == null) {
            throw new IllegalArgumentException("Cannot repaint a null DRectangle");
        }
        if (r.isAll() || this.autoFocus) {
            this.repaint();
        } else {
            Point p1 = this.measures.getPoint(r.getX(), r.getY());
            Point p2 = this.measures.getPoint(r.getX() + r.getWidth(), r.getY() + r.getHeight());
            if (p1 == null || p2 == null) {
                this.repaint();
            } else {
                DBorder b = this.getDBorder();
                this.repaint(p1.x - b.left, p2.y - b.top, p2.x - p1.x + 1 + b.left + b.right, p1.y - p2.y + 1 + b.top + b.bottom);
            }
        }
    }

    @Override
    public void restoreBorder() {
        this.dborder = this.container.getDBorder();
    }

    public void setAutoFocus(boolean b) {
        boolean old = this.autoFocus;
        this.autoFocus = b;
        if (old != b) {
            this.repaint();
        }
    }

    public void setAutoGrid(boolean b) {
        if (b) {
            this.grid.rectangle = this.getDRectangle();
            this.grid.setVisible(true);
        }
        if (b == this.autoGrid) {
            return;
        }
        this.autoGrid = b;
        this.repaint();
    }

    public void setGrid(double hor_dist, double ver_dist) {
        this.grid = new DGrid(this.visibleRect, hor_dist, ver_dist);
        this.grid.setDParent(this);
        this.autoGrid = false;
        this.repaint();
    }

    public void setGridColor(Color color) {
        this.grid.setColor(color);
    }

    public void setGridToFront(boolean aFlag) {
        boolean old = this.gridToFront;
        this.gridToFront = aFlag;
        if (old != aFlag && this.grid.isVisible()) {
            this.repaint();
        }
    }

    public void setGridVisible(boolean aFlag) {
        this.grid.rectangle = this.getDRectangle();
        this.grid.setVisible(aFlag);
    }

    public void setMaxGrid(int no) {
        if (no < 1) {
            return;
        }
        int old = this.maxGrid;
        this.maxGrid = no;
        if (old != no) {
            this.repaint();
        }
    }

    public void setMaxX(double max) {
        if (max < this.minRect.getX() + this.minRect.getWidth()) {
            throw new IllegalArgumentException("Maximal x-value axes intersects minmal rectangle.");
        }
        this.maxX = max;
    }

    public void setMaxY(double may) {
        if (may < this.minRect.getY() + this.minRect.getHeight()) {
            throw new IllegalArgumentException("Maximal y-value axes intersects minmal rectangle.");
        }
        this.maxY = may;
    }

    public void setMinRectangle(double x, double y, double width, double height) {
        this.setMinRectangle(new DRectangle(x, y, width, height));
    }

    public void setMinRectangle(DRectangle rect) {
        this.minRect = rect.isEmpty() ? DEFAULT_MIN_RECT : (DRectangle)rect.clone();
    }

    public void setMinX(double mix) {
        if (mix > this.minRect.getX()) {
            throw new IllegalArgumentException("Mimimal y-value axes intersects minmal rectangle.");
        }
        this.minX = mix;
    }

    public void setMinY(double miy) {
        if (miy > this.minRect.getY()) {
            throw new IllegalArgumentException("Mimimal y-value axes intersects minmal rectangle.");
        }
        this.minY = miy;
    }

    public void setVisibleRectangle(double x, double y, double width, double height) {
        this.setVisibleRectangle(new DRectangle(x, y, width, height));
    }

    public void setVisibleRectangle(DRectangle rect) {
        if (rect.isEmpty()) {
            throw new IllegalArgumentException("You should never try to set an empty rectangle\nas the visible rectangle of an DArea");
        }
        if (!rect.equals(this.visibleRect) && rect.getWidth() > 0.0 && rect.getHeight() > 0.0) {
            this.autoFocus = false;
            this.visibleRect = (DRectangle)rect.clone();
            this.repaint();
        }
    }

    public void setXScale(DFunction x_s) {
        if (x_s == null && this.measures.xScale == null) {
            return;
        }
        this.measures.xScale = x_s;
        this.repaint();
    }

    public void setYScale(DFunction y_s) {
        if (y_s == null && this.measures.yScale == null) {
            return;
        }
        this.measures.yScale = y_s;
        this.repaint();
    }
}

