/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.chart2d;

import eva2.tools.chart2d.DIntDoubleMap;

public class DArray
implements DIntDoubleMap {
    private int initialCapacity;
    private int size;
    private double capacityMultiplier = 2.0;
    private double max;
    private double min;
    private double minPositive = -1.0;
    private double[] value;

    public DArray() {
        this(5, 2.0);
    }

    public DArray(int initialCapacity) {
        this(initialCapacity, 2.0);
    }

    public DArray(int initialCapacity, double capacityMultiplier) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("The initial capacity has to be at least 1");
        }
        if (capacityMultiplier <= 1.0) {
            throw new IllegalArgumentException("The capacity multiplier has to be bigger than 1");
        }
        this.initialCapacity = initialCapacity;
        this.value = new double[initialCapacity];
        this.capacityMultiplier = capacityMultiplier;
    }

    @Override
    public boolean setImage(int source, double image) {
        if (source < 0 || source >= this.size) {
            throw new ArrayIndexOutOfBoundsException(source);
        }
        boolean minMaxChanged = false;
        boolean restore = false;
        if (image < this.min) {
            this.min = image;
            minMaxChanged = true;
        } else if (image > this.max) {
            this.max = image;
            minMaxChanged = true;
        }
        if (this.value[source] == this.min || this.value[source] == this.max || this.value[source] == this.minPositive) {
            restore = true;
        }
        this.value[source] = image;
        if (restore) {
            minMaxChanged = this.restore() || minMaxChanged;
        }
        return minMaxChanged;
    }

    @Override
    public double getImage(int source) {
        if (source < 0) {
            throw new ArrayIndexOutOfBoundsException(source);
        }
        if (source >= this.size && this.size > 1) {
            return this.value[this.size - 1];
        }
        return this.value[source];
    }

    @Override
    public boolean addImage(double image) {
        if (this.size >= this.value.length) {
            int newLength = (int)((double)this.value.length * this.capacityMultiplier);
            if (newLength <= this.value.length) {
                ++newLength;
            }
            double[] new_val = new double[newLength];
            System.arraycopy(this.value, 0, new_val, 0, this.value.length);
            this.value = new_val;
        }
        boolean minMaxChanged = false;
        if (this.size == 0) {
            this.min = image;
            this.max = image;
            minMaxChanged = true;
            if (image > 0.0) {
                this.minPositive = image;
            }
        } else {
            if (image > 0.0 && (image < this.minPositive || this.minPositive < 0.0)) {
                this.minPositive = image;
                minMaxChanged = true;
            }
            if (image > this.max) {
                this.max = image;
                minMaxChanged = true;
            } else if (image < this.min) {
                this.min = image;
                minMaxChanged = true;
            }
        }
        this.value[this.size++] = image;
        return minMaxChanged;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean restore() {
        if (this.size == 0) {
            return false;
        }
        double old_min = this.min;
        double old_max = this.max;
        this.min = this.value[0];
        this.max = this.value[0];
        this.minPositive = Double.POSITIVE_INFINITY;
        for (int i = 1; i < this.size; ++i) {
            if (this.value[i] > 0.0 && this.value[i] < this.minPositive) {
                this.minPositive = this.value[i];
            }
            if (this.value[i] < this.min) {
                this.min = this.value[i];
                continue;
            }
            if (!(this.value[i] > this.max)) continue;
            this.max = this.value[i];
        }
        if (Double.isInfinite(this.minPositive)) {
            this.minPositive = -1.0;
        }
        return old_min != this.min || old_max != this.max;
    }

    @Override
    public void reset() {
        this.size = 0;
        this.value = new double[this.initialCapacity];
    }

    @Override
    public double getMinImageValue() {
        if (this.size == 0) {
            throw new IllegalArgumentException("DArray is empty. No minimal value exists");
        }
        return this.min;
    }

    @Override
    public double getMinPositiveImageValue() {
        if (this.size == 0) {
            throw new IllegalArgumentException("DArray is empty. No minimal value exists");
        }
        return this.minPositive < 0.0 ? this.max : this.minPositive;
    }

    @Override
    public double getMaxImageValue() {
        if (this.size == 0) {
            throw new IllegalArgumentException("DArray is empty. No maximal value exists");
        }
        return this.max;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DArray)) {
            return false;
        }
        DArray comp = (DArray)o;
        if (comp.size != this.size) {
            return false;
        }
        if (comp.max != this.max) {
            return false;
        }
        if (comp.min != this.min) {
            return false;
        }
        if (comp.minPositive != this.minPositive) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (comp.value[i] == this.value[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String text = "eva2.tools.chart2d.DArray[size:" + this.size;
        if (this.size < 11) {
            for (int i = 0; i < this.size; ++i) {
                text = text + ", " + this.value[i];
            }
        }
        text = text + "]";
        return text;
    }

    public double[] toArray(double[] v) {
        if (v == null || v.length < this.size) {
            v = new double[this.size];
        }
        System.arraycopy(this.value, 0, v, 0, this.size);
        return v;
    }
}

