/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.chart2d;

import eva2.tools.chart2d.DBorder;
import eva2.tools.chart2d.DElement;
import eva2.tools.chart2d.DParent;
import eva2.tools.chart2d.DRectangle;
import java.awt.Color;

public abstract class DComponent
implements DElement {
    protected Color color;
    protected DRectangle rectangle;
    protected DParent parent;
    private boolean visible = true;
    private DBorder border = new DBorder();

    DComponent(boolean is_rect) {
    }

    public DComponent() {
        this.rectangle = DRectangle.getEmpty();
    }

    @Override
    public DRectangle getRectangle() {
        return (DRectangle)this.rectangle.clone();
    }

    @Override
    public void setDBorder(DBorder b) {
        if (this.parent != null) {
            if (this.border.insert(b)) {
                this.parent.addDBorder(b);
                this.repaint();
            } else {
                this.border = b;
                this.parent.restoreBorder();
            }
        } else {
            this.border = b;
        }
    }

    @Override
    public DBorder getDBorder() {
        return this.border;
    }

    @Override
    public void setDParent(DParent parent) {
        if (this.parent != null && this.parent != parent) {
            this.parent.removeDElement(this);
            this.parent.repaint(this.getRectangle());
        }
        this.parent = parent;
    }

    @Override
    public DParent getDParent() {
        return this.parent;
    }

    @Override
    public void repaint() {
        if (this.parent != null) {
            this.parent.repaint(this.getRectangle());
        }
    }

    @Override
    public void setColor(Color color) {
        if (this.color == null || !this.color.equals(color)) {
            this.color = color;
            this.repaint();
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setVisible(boolean aFlag) {
        boolean changed = aFlag != this.visible;
        this.visible = aFlag;
        if (changed) {
            this.repaint();
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void toggleVisible() {
        this.setVisible(!this.isVisible());
    }
}

