/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.chart2d;

import eva2.tools.chart2d.DBorder;
import eva2.tools.chart2d.DComponent;
import eva2.tools.chart2d.DElement;
import eva2.tools.chart2d.DMeasures;
import eva2.tools.chart2d.DParent;
import eva2.tools.chart2d.DRectangle;
import java.awt.Color;
import java.util.Vector;

public class DContainer
extends DComponent
implements DParent {
    protected Vector<DElement> elements;
    protected Vector<String> keys;

    public DContainer() {
        this(10);
    }

    public DContainer(int initial_capacity) {
        this.elements = new Vector(initial_capacity);
        this.keys = new Vector(initial_capacity);
    }

    @Override
    public void repaint(DRectangle r) {
        DParent parent = this.getDParent();
        if (parent != null) {
            parent.repaint(r);
        }
    }

    @Override
    public void addDElement(DElement e) {
        this.addDElement(null, e);
    }

    public void addDElement(String key, DElement e) {
        if (this.elements.contains(e)) {
            return;
        }
        if (e instanceof DParent) {
            DParent he = (DParent)((Object)e);
            DParent me = this;
            if (he == me) {
                throw new IllegalArgumentException("Adding DParent to itself");
            }
            me = this.getDParent();
            while (me != null) {
                if (he == me) {
                    throw new IllegalArgumentException("Adding DContainer's parent to itself");
                }
                if (me instanceof DElement) {
                    me = ((DElement)((Object)me)).getDParent();
                    continue;
                }
                me = null;
            }
        }
        this.elements.add(e);
        this.addDBorder(e.getDBorder());
        this.keys.add(key);
        e.setDParent(this);
        DRectangle r = e.getRectangle();
        this.rectangle.insert(r);
        if (e.isVisible()) {
            this.repaint(r);
        }
    }

    @Override
    public boolean removeDElement(DElement e) {
        int index = this.elements.indexOf(e);
        if (index > -1) {
            this.elements.remove(index);
            this.keys.remove(index);
            this.repaint(e.getRectangle());
            this.restore();
            return true;
        }
        return false;
    }

    public void removeAllDElements() {
        this.elements.removeAllElements();
        this.keys.removeAllElements();
        this.rectangle = DRectangle.getEmpty();
        this.repaint();
    }

    @Override
    public DElement[] getDElements() {
        DElement[] es = new DElement[this.elements.size()];
        this.elements.toArray(es);
        return es;
    }

    public DElement getDElement(String key) {
        int index = -1;
        for (int i = 0; index == -1 && i < this.keys.size(); ++i) {
            if (!this.keys.get(i).equals(key)) continue;
            index = i;
        }
        return index < this.keys.size() ? this.elements.get(index) : null;
    }

    @Override
    public void paint(DMeasures m) {
        for (int i = 0; i < this.elements.size(); ++i) {
            DElement e = this.elements.elementAt(i);
            if (!e.isVisible() || m.getSlimRectangle().hasEmptyIntersection(e.getRectangle())) continue;
            m.g.setColor(DEFAULT_COLOR);
            e.paint(m);
        }
    }

    @Override
    public boolean contains(DElement e) {
        return this.elements.contains(e);
    }

    @Override
    public void setColor(Color c) {
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).setColor(c);
        }
        super.setColor(c);
    }

    @Override
    public void addDBorder(DBorder b) {
        if (this.getDBorder().insert(b) && this.parent != null) {
            this.parent.addDBorder(b);
        }
    }

    @Override
    public void restoreBorder() {
        DBorder b = new DBorder();
        for (int i = 0; i < this.elements.size(); ++i) {
            b.insert(this.elements.get(i).getDBorder());
        }
        this.setDBorder(b);
    }

    boolean restore() {
        DRectangle old = (DRectangle)this.rectangle.clone();
        this.rectangle = DRectangle.getEmpty();
        this.setDBorder(new DBorder());
        for (int i = 0; i < this.elements.size(); ++i) {
            DElement elt = this.elements.elementAt(i);
            this.rectangle.insert(elt.getRectangle());
            this.addDBorder(elt.getDBorder());
        }
        return !old.equals(this.rectangle);
    }
}

