/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.chart2d;

import eva2.tools.chart2d.DComponent;
import eva2.tools.chart2d.DMeasures;
import eva2.tools.chart2d.DRectangle;
import eva2.tools.chart2d.SlimRect;
import java.awt.Graphics;
import java.awt.Point;

public abstract class DFunction
extends DComponent {
    public DFunction() {
        this.rectangle = DRectangle.getAll();
    }

    public abstract boolean isDefinedAt(double var1);

    public abstract boolean isInvertibleAt(double var1);

    public abstract double getSourceOf(double var1) throws IllegalArgumentException;

    public abstract double getImageOf(double var1) throws IllegalArgumentException;

    @Override
    public void paint(DMeasures m) {
        Graphics g = m.getGraphics();
        if (this.color != null) {
            g.setColor(this.color);
        }
        SlimRect rect = m.getSlimRectangle();
        SlimRect src_rect = m.getSourceOf(rect);
        Point sw = m.getPoint(rect.x, rect.y);
        Point ne = m.getPoint(rect.x + rect.width, rect.y + rect.height);
        int int_w = ne.x - sw.x;
        Point last = null;
        for (int i = 0; i < int_w; ++i) {
            double x_val = src_rect.x + (double)i / (double)int_w * src_rect.width;
            if (m.xScale != null) {
                x_val = m.xScale.getImageOf(x_val);
            }
            if (this.isDefinedAt(x_val)) {
                Point next = m.getPoint(x_val, this.getImageOf(x_val));
                if (last != null) {
                    g.drawLine(last.x, last.y, next.x, next.y);
                }
                last = next;
                continue;
            }
            last = null;
        }
    }
}

