/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.chart2d;

import eva2.tools.chart2d.DComponent;
import eva2.tools.chart2d.DLine;
import eva2.tools.chart2d.DMeasures;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DRectangle;
import eva2.tools.math.Mathematics;
import java.awt.Color;
import java.awt.Graphics;

public class DGrid
extends DComponent {
    private double horDist;
    private double verDist;
    private Color DEFAULT_COLOR = Color.lightGray;

    public DGrid(DRectangle rectangle, double horDist, double verDist) {
        this.rectangle = rectangle;
        this.horDist = horDist;
        this.verDist = verDist;
        this.color = this.DEFAULT_COLOR;
    }

    public DGrid(DRectangle rectangle, double horDist, double verDist, Color color) {
        this.rectangle = rectangle;
        this.horDist = horDist;
        this.verDist = verDist;
        this.color = color;
    }

    public void setDistances(double hor, double ver) {
        this.horDist = hor;
        this.verDist = ver;
    }

    public double getHorDist() {
        return this.horDist;
    }

    public double getVerDist() {
        return this.verDist;
    }

    @Override
    public void paint(DMeasures m) {
        DLine l;
        double pos;
        Graphics g = m.getGraphics();
        if (this.color != null) {
            g.setColor(this.color);
        }
        double minX = Mathematics.firstMultipleAbove(this.rectangle.getX(), this.horDist);
        double minY = Mathematics.firstMultipleAbove(this.rectangle.getY(), this.verDist);
        DPoint p1 = new DPoint(0.0, this.rectangle.getY());
        DPoint p2 = new DPoint(0.0, this.rectangle.getY() + this.rectangle.getHeight());
        for (pos = minX; pos <= this.rectangle.getX() + this.rectangle.getWidth(); pos += this.horDist) {
            p1.x = p2.x = pos;
            l = new DLine(p1, p2, this.color);
            l.paint(m);
        }
        p1.x = this.rectangle.getX();
        p2.x = p1.x + this.rectangle.getWidth();
        pos = minY;
        while (pos <= this.rectangle.getY() + this.rectangle.getHeight()) {
            p1.y = p2.y = pos;
            l = new DLine(p1, p2, this.color);
            l.paint(m);
            if (pos + this.verDist <= pos) {
                System.err.println("Overflow error in DGrid!");
                pos *= 1.01;
                continue;
            }
            pos += this.verDist;
        }
    }

    public String toString() {
        return "chart2d.DGrid[ hor: " + this.horDist + ", ver: " + this.verDist + " ]";
    }
}

