/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.chart2d;

import eva2.tools.chart2d.DComponent;
import eva2.tools.chart2d.DMeasures;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DRectangle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class DLine
extends DComponent {
    DPoint start;
    DPoint end;

    public DLine(double x1, double y1, double x2, double y2) {
        this(new DPoint(x1, y1), new DPoint(x2, y2));
    }

    public DLine(DPoint start, DPoint end) {
        this.start = start;
        this.end = end;
    }

    public DLine(double x1, double y1, double x2, double y2, Color color) {
        this(new DPoint(x1, y1), new DPoint(x2, y2), color);
    }

    public DLine(DPoint start, DPoint end, Color color) {
        this.start = start;
        this.end = end;
        this.color = color;
    }

    @Override
    public DRectangle getRectangle() {
        double x = this.start.x;
        double y = this.start.y;
        double width = this.end.x - x;
        double height = this.end.y - y;
        if (width < 0.0) {
            x += width;
            width *= -1.0;
        }
        if (height < 0.0) {
            y += height;
            height *= -1.0;
        }
        return new DRectangle(x, y, width, height);
    }

    @Override
    public void paint(DMeasures m) {
        Graphics g = m.getGraphics();
        if (this.color != null) {
            g.setColor(this.color);
        }
        Point p1 = m.getPoint(this.start.x, this.start.y);
        Point p2 = m.getPoint(this.end.x, this.end.y);
        if (p1 != null && p2 != null) {
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
        } else {
            System.err.println("Couldnt paint rect!");
        }
    }

    public String toString() {
        return "DLine[(" + this.start.x + "," + this.start.y + ") --> (" + this.end.x + "," + this.end.y + ", color: " + this.color + "]";
    }
}

