/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.chart2d;

import eva2.tools.chart2d.DArea;
import eva2.tools.chart2d.DFunction;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.ScaledBorder;
import eva2.tools.chart2d.SlimRect;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.io.Serializable;

public class DMeasures
implements Serializable {
    private static final long serialVersionUID = 243092480517044848L;
    Graphics g;
    ScaledBorder sb;
    DFunction xScale;
    DFunction yScale;
    Component comp;
    Insets insets;

    DMeasures(DArea area) {
        this.comp = area;
    }

    DMeasures(ScaledBorder sb) {
        this.sb = sb;
    }

    public Point getPoint(double x, double y) {
        SlimRect rect = this.getSourceOf(this.getSlimRectangle());
        if (rect == null) {
            return null;
        }
        try {
            if (this.xScale != null) {
                x = this.xScale.getSourceOf(x);
            }
            if (this.yScale != null) {
                y = this.yScale.getSourceOf(y);
            }
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        Point dp = new Point();
        Dimension dim = this.getInner();
        Insets insets = this.getInsets();
        dp.x = (int)((double)dim.width * (x - rect.x) / rect.width) + insets.left;
        dp.y = (int)((double)dim.height * (1.0 - (y - rect.y) / rect.height)) + insets.top;
        return dp;
    }

    public DPoint getDPoint(int x, int y) {
        SlimRect rect = this.getSourceOf(this.getSlimRectangle());
        Dimension dim = this.getInner();
        Insets insets = this.getInsets();
        double dx = rect.x + rect.width * (double)(x -= insets.left) / (double)dim.width;
        double dy = rect.y + rect.height * (1.0 - (double)(y -= insets.top) / (double)dim.height);
        try {
            if (this.xScale != null) {
                dx = this.xScale.getImageOf(dx);
            }
            if (this.yScale != null) {
                dy = this.yScale.getImageOf(dy);
            }
        }
        catch (IllegalArgumentException nde) {
            return null;
        }
        return new DPoint(dx, dy);
    }

    public SlimRect getSlimRectangle() {
        if (this.sb != null) {
            return this.getImageOf(this.sb.srcRect.x, this.sb.srcRect.y, this.sb.srcRect.width, this.sb.srcRect.height);
        }
        return ((DArea)this.comp).getSlimRectangle();
    }

    public Graphics getGraphics() {
        if (this.g != null) {
            Dimension d = this.comp.getSize();
            Insets insets = this.getInsets();
            this.g.setClip(insets.left + 1, insets.top, d.width - insets.left - insets.right, d.height - insets.top - insets.bottom);
        }
        return this.g;
    }

    void setGraphics(Graphics g) {
        this.g = g;
    }

    void update(Component c, Insets insets) {
        this.comp = c;
        this.insets = insets;
        this.xScale = this.sb.xScale;
        this.yScale = this.sb.yScale;
    }

    private Dimension getInner() {
        Dimension d = this.comp.getSize();
        Insets insets = this.getInsets();
        d.width -= insets.left + insets.right;
        d.height -= insets.top + insets.bottom;
        return d;
    }

    SlimRect getImageOf(double xpos, double ypos, double width, double height) {
        if (this.xScale == null && this.yScale == null) {
            return new SlimRect(xpos, ypos, width, height);
        }
        double x1 = xpos;
        double y1 = ypos;
        double x2 = xpos + width;
        double y2 = ypos + height;
        try {
            if (this.xScale != null) {
                x1 = this.xScale.getImageOf(x1);
                x2 = this.xScale.getImageOf(x2);
            }
            if (this.yScale != null) {
                y1 = this.yScale.getImageOf(y1);
                y2 = this.yScale.getImageOf(y2);
            }
        }
        catch (IllegalArgumentException nde) {
            return null;
        }
        return new SlimRect(x1, y1, x2 - x1, y2 - y1);
    }

    SlimRect getImageOf(SlimRect srect) {
        return this.getImageOf(srect.x, srect.y, srect.width, srect.height);
    }

    SlimRect getSourceOf(double x, double y, double width, double height) {
        if (!this.getSlimRectangle().contains(x, y, width, height)) {
            return null;
        }
        if (this.xScale == null && this.yScale == null) {
            return new SlimRect(x, y, width, height);
        }
        double x1 = x;
        double y1 = y;
        double x2 = x + width;
        double y2 = y + height;
        try {
            if (this.xScale != null) {
                x1 = this.xScale.getSourceOf(x1);
                x2 = this.xScale.getSourceOf(x2);
            }
            if (this.yScale != null) {
                y1 = this.yScale.getSourceOf(y1);
                y2 = this.yScale.getSourceOf(y2);
            }
        }
        catch (IllegalArgumentException nde) {
            return null;
        }
        catch (NullPointerException npe) {
            return null;
        }
        return new SlimRect(x1, y1, x2 - x1, y2 - y1);
    }

    SlimRect getSourceOf(SlimRect srect) {
        return this.getSourceOf(srect.x, srect.y, srect.width, srect.height);
    }

    private Insets getInsets() {
        if (this.sb != null) {
            return this.insets;
        }
        return ((DArea)this.comp).getInsets();
    }
}

