/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.chart2d;

import eva2.tools.chart2d.DBorder;
import eva2.tools.chart2d.DComponent;
import eva2.tools.chart2d.DMeasures;
import eva2.tools.chart2d.DPointIcon;
import eva2.tools.chart2d.DRectangle;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;

public class DPoint
extends DComponent {
    public double x;
    public double y;
    public String label;
    protected DPointIcon icon = null;

    public DPoint() {
    }

    public void initpoint(double x, double y) {
        this.x = x;
        this.y = y;
        this.rectangle = new DRectangle(x, y, 0.0, 0.0);
    }

    public DPoint(double x, double y) {
        this.x = x;
        this.y = y;
        this.rectangle = new DRectangle(x, y, 0.0, 0.0);
    }

    @Override
    public void paint(DMeasures m) {
        Graphics g = m.getGraphics();
        if (this.color != null) {
            g.setColor(this.color);
        }
        Point dp = m.getPoint(this.x, this.y);
        if (this.label != null) {
            FontMetrics fm = g.getFontMetrics();
            g.drawString(this.label, dp.x - fm.stringWidth(this.label) / 2, dp.y + fm.getAscent());
        }
        if (this.icon == null) {
            g.drawRect(dp.x, dp.y, 1, 1);
        } else {
            g.translate(dp.x, dp.y);
            this.icon.paint(g);
            g.translate(-dp.x, -dp.y);
        }
    }

    public void setIcon(DPointIcon icon) {
        this.icon = icon;
        if (icon == null) {
            this.setDBorder(new DBorder(1, 1, 1, 1));
        } else {
            this.setDBorder(icon.getDBorder());
        }
    }

    public DPointIcon getIcon() {
        return this.icon;
    }

    public Object clone() {
        DPoint copy = new DPoint(this.x, this.y);
        copy.color = this.color;
        return copy;
    }

    public String toString() {
        String text = "DPoint[";
        if (this.label != null) {
            text = text + this.label + ", ";
        }
        text = text + "x: " + this.x + ", y: " + this.y + ", color: " + this.color + "]";
        return text;
    }
}

