/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.chart2d;

import eva2.gui.InterfaceSelectablePointIcon;
import eva2.gui.plot.InterfaceDPointWithContent;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.mocco.paretofrontviewer.InterfaceRefSolutionListener;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.chart2d.DBorder;
import eva2.tools.chart2d.DPointIcon;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class DPointContentSelectable
implements InterfaceDPointWithContent,
InterfaceSelectablePointIcon,
DPointIcon {
    AbstractEAIndividual individual;
    InterfaceOptimizationProblem optimizationProblem;
    private InterfaceRefSolutionListener refSolutionListener;
    private Color borderColor = Color.BLACK;
    private Color fillColor = null;
    private int size = 4;

    @Override
    public void paint(Graphics g) {
        Color prev = g.getColor();
        this.fillColor = this.individual.isMarked() ? Color.RED : Color.LIGHT_GRAY;
        g.setColor(this.fillColor);
        g.fillOval(-this.size, -this.size, 2 * this.size + 1, 2 * this.size + 1);
        if (this.borderColor != null) {
            g.setColor(this.borderColor);
        }
        g.drawOval(-this.size, -this.size, 2 * this.size, 2 * this.size);
        g.setColor(prev);
    }

    @Override
    public DBorder getDBorder() {
        return new DBorder(4, 4, 4, 4);
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
    }

    public void setFillColor(Color c) {
        this.fillColor = c;
    }

    public void setSize(int d) {
        this.size = d;
    }

    @Override
    public void addSelectionListener(InterfaceRefSolutionListener a) {
        this.refSolutionListener = a;
    }

    @Override
    public InterfaceRefSolutionListener getSelectionListener() {
        return this.refSolutionListener;
    }

    @Override
    public void removeSelectionListeners() {
        this.refSolutionListener = null;
    }

    @Override
    public void setEAIndividual(AbstractEAIndividual indy) {
        this.individual = indy;
    }

    @Override
    public AbstractEAIndividual getEAIndividual() {
        return this.individual;
    }

    @Override
    public void setProblem(InterfaceOptimizationProblem problem) {
        this.optimizationProblem = problem;
    }

    @Override
    public InterfaceOptimizationProblem getProblem() {
        return this.optimizationProblem;
    }

    @Override
    public void showIndividual() {
        JFrame newFrame = new JFrame();
        newFrame.setTitle(this.individual.getName() + ": " + this.individual);
        newFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                System.gc();
            }
        });
        newFrame.getContentPane().add(this.optimizationProblem.drawIndividual(-1, -1, this.individual));
        newFrame.setSize(200, 300);
        newFrame.pack();
        newFrame.validate();
        newFrame.setVisible(true);
    }
}

